/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.extvar;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;

public class ExternalVariableConf {
    public static final QName EXTVARCONF_ELEMENT = new QName("http://ode.apache.org/externalVariables", "externalVariable");
    private final HashMap<String, Variable> _vars = new HashMap();

    public ExternalVariableConf(List<Element> els) {
        for (Element el : els) {
            String varId = el.getAttribute("id");
            if (varId == null || "".equals(varId)) {
                throw new BpelEngineException("Invalid external variable configuration; id not specified.");
            }
            if (this._vars.containsKey(varId)) {
                throw new BpelEngineException("Invalid external variable configuration; duplicate id \"" + varId + " \".");
            }
            Element child = DOMUtils.getFirstChildElement(el);
            if (child == null) {
                throw new BpelEngineException("Invalid external variable configuration for id \"" + varId + "\"; no engine configuration!");
            }
            QName engineQName = new QName(child.getNamespaceURI(), child.getLocalName());
            Variable var = new Variable(varId, engineQName, child);
            this._vars.put(varId, var);
        }
    }

    public Variable getVariable(String id) {
        return this._vars.get(id);
    }

    public Collection<Variable> getVariables() {
        return this._vars.values();
    }

    public class Variable {
        public final String extVariableId;
        public final QName engineQName;
        public final Element configuration;

        Variable(String id, QName engine, Element config) {
            this.extVariableId = id;
            this.engineQName = engine;
            this.configuration = config;
        }
    }
}

