/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.ode.utils.VersionMessages;
import org.apache.ode.utils.msg.MessageBundle;

public class Version {
    private static String MINOR_VERSION = "";
    private static String MAJOR_VERSION = "";
    private static String VERSION_NAME = "UNRELEASED";
    private static String BUILD_NUMBER = "";
    private static String BUILD_DATE = "UNKNOWN";

    public static String getVersionName() {
        return VERSION_NAME;
    }

    public static String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public static String getBuildDate() {
        return BUILD_DATE;
    }

    public static int getMajorVersion() {
        if (MAJOR_VERSION.length() == 0) {
            return -1;
        }
        return Integer.parseInt(MAJOR_VERSION);
    }

    public static int getMinorVersion() {
        if (MINOR_VERSION.length() == 0) {
            return -1;
        }
        return Integer.parseInt(MINOR_VERSION);
    }

    public static void main(String[] argv) {
        VersionMessages msgs = MessageBundle.getMessages(VersionMessages.class);
        System.out.println(msgs.msgVersionInfo(Version.getVersionName(), Version.getBuildDate()));
        System.out.println(msgs.msgGetCopyright());
    }

    static {
        Properties props = new Properties();
        InputStream is = Version.class.getResourceAsStream("/ODE.version");
        if (is != null) {
            try {
                props.load(is);
                BUILD_NUMBER = props.getProperty("build.number", "");
                MAJOR_VERSION = props.getProperty("version.major", "");
                MINOR_VERSION = props.getProperty("version.minor", "");
                VERSION_NAME = props.getProperty("version.name", "UNRELEASED");
                BUILD_DATE = props.getProperty("build.date", "UNKNOWN");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

