/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server.plugin;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.overlord.commons.services.ServiceRegistryUtil;

public class PluginMgr {
    private static final Log log = LogFactory.getLog(PluginMgr.class);
    private static List<String> failedToResolve = new CopyOnWriteArrayList<String>();

    public static <T> T load(Class<T> type) {
        boolean failedBefore = failedToResolve.contains(type.getName());
        if (failedBefore) {
            return null;
        }
        Object pluginImpl = ServiceRegistryUtil.getSingleService(type);
        if (pluginImpl != null) {
            log.info((Object)("Successfully loaded plugin '" + type.getName() + "': " + pluginImpl.getClass()));
            return (T)pluginImpl;
        }
        failedToResolve.add(type.getName());
        return null;
    }
}

