/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.extvar.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.extvar.jdbc.DbExternalVariable;

class RowSubset
extends ArrayList<Object> {
    private static final Log LOG = LogFactory.getLog(RowSubset.class);
    private static final long serialVersionUID = 1L;
    protected List<DbExternalVariable.Column> _columns;
    protected HashMap<String, DbExternalVariable.Column> _colmap = new HashMap();

    RowSubset(List<DbExternalVariable.Column> columns) {
        this._columns = columns;
        for (DbExternalVariable.Column c : columns) {
            this.add(null);
            this._colmap.put(c.name, c);
        }
    }

    boolean missingValues() {
        for (DbExternalVariable.Column c : this._columns) {
            if (this.get(c.idx) != null) continue;
            return true;
        }
        return false;
    }

    boolean missingDatabaseGeneratedValues() {
        for (DbExternalVariable.Column c : this._columns) {
            Object value = this.get(c.idx);
            if (!c.isDatabaseGenerated() || value != null) continue;
            return true;
        }
        return false;
    }

    DbExternalVariable.Column getColumn(String name) {
        return this._colmap.get(name);
    }

    DbExternalVariable.Column getColumn(int idx) {
        return this._columns.get(idx);
    }

    Object get(String name) {
        DbExternalVariable.Column c = this._colmap.get(name);
        if (c == null) {
            return null;
        }
        int idx = this._columns.indexOf(c);
        return this.get(idx);
    }

    void put(String name, Object val) {
        DbExternalVariable.Column c = this._colmap.get(name);
        if (c == null) {
            return;
        }
        int idx = this._columns.indexOf(c);
        this.set(idx, val);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getSimpleName());
        buf.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this._columns.get((int)i).name);
            buf.append("=");
            buf.append(this.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

