/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.deploy;

import java.io.InputStream;
import java.util.EventObject;
import java.util.Properties;
import org.apache.ode.bpel.evt.BpelEvent;
import org.jboss.logging.Logger;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineFactory;
import org.riftsaw.engine.BPELEngineListener;
import org.riftsaw.engine.ServiceLocator;
import org.switchyard.ServiceDomain;
import org.switchyard.component.bpel.BPELLogger;
import org.switchyard.component.bpel.BPELMessages;
import org.switchyard.component.bpel.deploy.BPELActivator;
import org.switchyard.component.bpel.riftsaw.RiftsawServiceLocator;
import org.switchyard.config.Configuration;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.BaseComponent;

public class BPELComponent
extends BaseComponent {
    private static final Logger LOG = Logger.getLogger(BPELComponent.class);
    private final BPELEngineInstance _bpelEngineInstance;
    private static Properties _config;
    private static BPELEngine _engine;
    private static boolean _initialized;

    public BPELComponent() {
        this(new BPELEngineInstanceImpl());
    }

    protected BPELComponent(BPELEngineInstance bpelEngineInstance) {
        super(new String[]{"bpel"});
        this.setName("BPELComponent");
        this._bpelEngineInstance = bpelEngineInstance;
    }

    public void init(Configuration config) {
        super.init(config);
        this.initConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConfig() {
        Class<BPELComponent> clazz = BPELComponent.class;
        synchronized (BPELComponent.class) {
            if (_initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            BPELLogger.ROOT_LOGGER.initBPELComponent();
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                _config = new Properties();
                try {
                    InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("bpel.properties");
                    _config.load(is);
                }
                catch (Exception e) {
                    throw BPELMessages.MESSAGES.failedToLoadDefaultProperties(e);
                }
                if (this.getConfig() != null) {
                    for (Configuration child : this.getConfig().getChildren()) {
                        if (LOG.isDebugEnabled()) {
                            if (_config.containsKey(child.getName())) {
                                LOG.debug((Object)("Overriding BPEL property: " + child.getName() + " = " + child.getValue()));
                            } else {
                                LOG.debug((Object)("Setting BPEL property: " + child.getName() + " = " + child.getValue()));
                            }
                        }
                        _config.put(child.getName(), child.getValue());
                    }
                }
                this._bpelEngineInstance.init(new RiftsawServiceLocator(), _config);
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            _initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BPELEngine getEngine(final ServiceDomain domain) {
        Class<BPELComponent> clazz = BPELComponent.class;
        synchronized (BPELComponent.class) {
            if (_engine == null) {
                this.initConfig();
                try {
                    _engine = this._bpelEngineInstance.getBPELEngine();
                }
                catch (Exception e) {
                    throw BPELMessages.MESSAGES.failedToInitializeTheEngine(e);
                }
                _engine.register(new BPELEngineListener(){

                    @Override
                    public void onEvent(BpelEvent bpelEvent) {
                        domain.getEventPublisher().publish((EventObject)bpelEvent);
                    }
                });
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        BPELLogger.ROOT_LOGGER.destroyBPELComponent();
        Class<BPELComponent> clazz = BPELComponent.class;
        synchronized (BPELComponent.class) {
            if (_engine != null) {
                try {
                    BPELEngine bPELEngine = _engine;
                    synchronized (bPELEngine) {
                        this._bpelEngineInstance.dispose();
                        _engine = null;
                    }
                }
                catch (Exception e) {
                    BPELLogger.ROOT_LOGGER.failedToCloseBPELEngine(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Activator createActivator(ServiceDomain domain) {
        if (domain == null) {
            throw new NullPointerException("domain cannot be null");
        }
        BPELEngine engine = this.getEngine(domain);
        BPELActivator activator = new BPELActivator(engine, (RiftsawServiceLocator)engine.getServiceLocator(), _config);
        activator.setServiceDomain(domain);
        return activator;
    }

    private static final class BPELEngineInstanceImpl
    implements BPELEngineInstance {
        private BPELEngine _engine;

        private BPELEngineInstanceImpl() {
        }

        @Override
        public synchronized void init(ServiceLocator serviceLocator, Properties config) {
            BPELEngineFactory.setConfig(config);
            BPELEngineFactory.setServiceLocator(serviceLocator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized BPELEngine getBPELEngine() throws Exception {
            if (this._engine == null) {
                ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this._engine = BPELEngineFactory.getEngine();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origTCCL);
                }
            }
            return this._engine;
        }

        @Override
        public synchronized void dispose() throws Exception {
            if (this._engine != null) {
                this._engine.close();
                this._engine = null;
            }
        }
    }

    protected static interface BPELEngineInstance {
        public void init(ServiceLocator var1, Properties var2);

        public BPELEngine getBPELEngine() throws Exception;

        public void dispose() throws Exception;
    }
}

