/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.osgi;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.ServiceLocator;
import org.riftsaw.engine.internal.BPELEngineImpl;
import org.riftsaw.engine.internal.DeploymentManager;

public class BPELEngineFactory {
    private ServiceLocator _serviceLocator;
    private Properties _configuration;
    private TransactionManager _transactionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BPELEngine createEngine() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            BPELEngineImpl engine = new BPELEngineImpl();
            engine.setTransactionManager(this._transactionManager);
            engine.setDeploymentManager(this.createDeploymentManager());
            engine.init(this._serviceLocator, this._configuration);
            BPELEngineImpl bPELEngineImpl = engine;
            return bPELEngineImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this._serviceLocator = serviceLocator;
    }

    public void setConfiguration(Properties configuration) {
        this._configuration = configuration;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this._transactionManager = transactionManager;
    }

    private DeploymentManager createDeploymentManager() throws IOException {
        DeploymentManager manager = new DeploymentManager();
        manager.setDeploymentFolder(this.getDeploymentsDirectory().getCanonicalPath());
        return manager;
    }

    private File getDeploymentsDirectory() {
        Bundle bundle2 = FrameworkUtil.getBundle(this.getClass());
        File dataDirectory = bundle2.getDataFile("");
        File deploymentsDirectory = new File(dataDirectory, "deployments");
        if (!deploymentsDirectory.exists()) {
            deploymentsDirectory.mkdir();
            deploymentsDirectory.deleteOnExit();
        }
        return deploymentsDirectory;
    }
}

