/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.cron;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dd.TCleanup;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.schedules.SchedulesDocument;
import org.apache.ode.bpel.schedules.TSchedule;
import org.apache.ode.store.ProcessCleanupConfImpl;
import org.apache.ode.utils.CronExpression;
import org.apache.xmlbeans.XmlOptions;

public class SystemSchedulesConfig {
    private static final Log __log = LogFactory.getLog(SystemSchedulesConfig.class);
    public static final String SCHEDULE_CONFIG_FILE_PROP_KEY = "org.apache.ode.scheduleConfigFile";
    private File schedulesFile;

    public SystemSchedulesConfig(File configRoot) {
        String scheduleConfigFile = System.getProperty(SCHEDULE_CONFIG_FILE_PROP_KEY);
        if (scheduleConfigFile != null) {
            this.schedulesFile = new File(scheduleConfigFile);
            if (!new File(scheduleConfigFile).exists()) {
                __log.warn((Object)("A custom location for schedules has been set. However, the file does not exist at the location: " + this.schedulesFile.getAbsolutePath() + ". The file will be read when one gets created."));
            }
        } else {
            assert (configRoot != null);
            this.schedulesFile = new File(configRoot, "schedules.xml");
        }
        __log.info((Object)("SYSTEM CRON configuration: " + this.schedulesFile.getAbsolutePath()));
    }

    public File getSchedulesFile() {
        return this.schedulesFile;
    }

    public List<ProcessConf.CronJob> getSystemCronJobs() {
        ArrayList<ProcessConf.CronJob> jobs = new ArrayList<ProcessConf.CronJob>();
        if (this.schedulesFile != null && this.schedulesFile.exists()) {
            for (TSchedule schedule : this.getSystemSchedulesDocument().getSchedules().getScheduleList()) {
                ProcessConf.CronJob job = new ProcessConf.CronJob();
                try {
                    job.setCronExpression(new CronExpression(schedule.getWhen()));
                    for (TCleanup aCleanup : schedule.getCleanupList()) {
                        ProcessConf.CleanupInfo cleanupInfo = new ProcessConf.CleanupInfo();
                        assert (!aCleanup.getFilterList().isEmpty());
                        cleanupInfo.setFilters(aCleanup.getFilterList());
                        ProcessCleanupConfImpl.processACleanup(cleanupInfo.getCategories(), aCleanup.getCategoryList());
                        Scheduler.JobDetails runnableDetails = new Scheduler.JobDetails();
                        runnableDetails.getDetailsExt().put("cleanupInfo", cleanupInfo);
                        runnableDetails.getDetailsExt().put("transactionSize", 10);
                        job.getRunnableDetailList().add(runnableDetails);
                        __log.info((Object)("SYSTEM CRON configuration added a runtime data cleanup: " + runnableDetails));
                    }
                    jobs.add(job);
                }
                catch (ParseException pe) {
                    __log.error((Object)("Exception during parsing the schedule cron expression: " + schedule.getWhen() + ", skipped the scheduled job."), (Throwable)pe);
                }
            }
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("SYSTEM CRON configuration found cron jobs: " + jobs));
        }
        return jobs;
    }

    private SchedulesDocument getSystemSchedulesDocument() {
        SchedulesDocument sd = null;
        try {
            XmlOptions options = new XmlOptions();
            HashMap<String, String> otherNs = new HashMap<String, String>();
            otherNs.put("http://ode.fivesight.com/schemas/2006/06/27/dd", "http://www.apache.org/ode/schemas/schedules/2009/05");
            options.setLoadSubstituteNamespaces(otherNs);
            sd = SchedulesDocument.Factory.parse(this.schedulesFile, options);
        }
        catch (Exception e) {
            throw new ContextException("Couldn't read schedule descriptor at location " + this.schedulesFile.getAbsolutePath(), e);
        }
        return sd;
    }
}

