/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.IdGen;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ScopeDAO;

class CorrelationSetDaoImpl
extends DaoBaseImpl
implements CorrelationSetDAO {
    private Long _csetId;
    private ScopeDAO _scope;
    private String _name;
    private CorrelationKey _key;
    private HashMap<QName, String> _corrValues;

    public CorrelationSetDaoImpl(String name, ScopeDAO scope) {
        this._name = name;
        this._scope = scope;
        this._csetId = IdGen.newCorrelationSetId();
    }

    @Override
    public Long getCorrelationSetId() {
        return this._csetId;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ScopeDAO getScope() {
        return this._scope;
    }

    @Override
    public void setValue(QName[] names, CorrelationKey values) {
        this._key = values;
        if (names != null) {
            this._corrValues = new HashMap();
            for (int m = 0; m < names.length; ++m) {
                this._corrValues.put(names[m], values.getValues()[m]);
            }
        }
    }

    @Override
    public CorrelationKey getValue() {
        return this._key;
    }

    @Override
    public Map<QName, String> getProperties() {
        return this._corrValues;
    }

    @Override
    public ProcessDAO getProcess() {
        return this.getScope().getProcessInstance().getProcess();
    }

    @Override
    public ProcessInstanceDAO getInstance() {
        return this.getScope().getProcessInstance();
    }
}

