/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.ode.utils.NSContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NamespaceStack {
    private Frame _current = new Frame();

    public NamespaceStack() {
        this._current.declarePrefix("xmlns", "http://www.w3.org/2000/xmlns/");
        this._current.declarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        this._current.declarePrefix("", "");
    }

    public NSContext toNSContext() {
        NSContext n = new NSContext();
        Frame f = this._current;
        while (f != null) {
            if (f._bindings != null) {
                for (String pfx : f._bindings.keySet()) {
                    if (n.getNamespaceURI(pfx) != null) continue;
                    n.register(pfx, f._bindings.get(pfx));
                }
            }
            f = f._parent;
        }
        return n;
    }

    public void pushNewContext() {
        this._current = new Frame(this._current);
    }

    public void pop() {
        if (this._current._parent == null) {
            throw new EmptyStackException();
        }
        this._current = this._current._parent;
    }

    public void declarePrefix(String prefix, String uri) {
        this._current.declarePrefix(prefix == null ? "" : prefix, uri == null ? "" : uri);
    }

    public String getNamespaceUri(String prefix) {
        return this._current.getNamespaceURI(prefix == null ? "" : prefix);
    }

    public void startPrefixMappings(ContentHandler ch) throws SAXException {
        this._current.startPrefixMappings(ch);
    }

    public void endPrefixMappings(ContentHandler ch) throws SAXException {
        this._current.endPrefixMappings(ch);
    }

    public String allocatePrefix(String hint, String uri) {
        String pfx = this.getPrefix(uri);
        if (pfx == null) {
            String u = this.getNamespaceUri(hint = hint == null ? "ns" : hint);
            if (u == null) {
                this.declarePrefix(hint, uri);
                pfx = hint;
            } else if (u.equals(uri)) {
                pfx = hint;
            }
        }
        return pfx;
    }

    public String getPrefix(String uri) {
        return this.toNSContext().getPrefix(uri);
    }

    public QName dereferenceQName(String qname) {
        QName qn;
        if (qname == null) {
            throw new IllegalArgumentException("Unable to dereference <null> as a QName.");
        }
        int pos = qname.indexOf(58);
        if (pos == qname.length() - 1 || pos == 0) {
            throw new IllegalArgumentException("\"" + qname + "\" is a malformed QName.");
        }
        if (pos == -1) {
            qn = new QName(this.getNamespaceUri(""), qname);
        } else {
            String uri = this.getNamespaceUri(qname.substring(0, pos));
            if (uri == null) {
                throw new IllegalArgumentException("No URI is bound to " + qname.substring(0, pos) + ".");
            }
            qn = new QName(uri, qname.substring(pos + 1));
        }
        return qn;
    }

    private class Frame {
        Frame _parent;
        HashMap<String, String> _bindings;

        Frame() {
        }

        Frame(Frame parent) {
            this._parent = parent;
        }

        void startPrefixMappings(ContentHandler ch) throws SAXException {
            if (this._bindings != null) {
                for (String prefix : this._bindings.keySet()) {
                    ch.startPrefixMapping(prefix, this._bindings.get(prefix));
                }
            }
        }

        void endPrefixMappings(ContentHandler ch) throws SAXException {
            if (this._bindings != null) {
                Iterator<String> it = this._bindings.keySet().iterator();
                while (it.hasNext()) {
                    ch.endPrefixMapping(it.next());
                }
            }
        }

        void declarePrefix(String prefix, String uri) {
            if (this._bindings == null) {
                this._bindings = new HashMap();
            }
            this._bindings.put(prefix, uri);
        }

        String getPrefix(String uri) {
            return "";
        }

        String getNamespaceURI(String prefix) {
            String uri = null;
            if (this._bindings != null) {
                uri = this._bindings.get(prefix);
            }
            if (uri == null) {
                uri = this._parent == null ? null : this._parent.getNamespaceURI(prefix);
            }
            return uri;
        }
    }
}

