/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.wsdl;

import javax.xml.namespace.QName;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Node;

public class Messages
extends MessageBundle {
    public String msgDuplicateWSDLImport(String tns, String location) {
        return this.format("Attempted to import WSDL for namespace {0} from multiple locations: definitions from {1} will be ignored", tns, location);
    }

    public String msgWsdlImportNotFound(String wsdlUri, String location) {
        return this.format("The WSDL for namespace \"{0}\" could not be found in \"{1}\".", wsdlUri, location);
    }

    public String msgNoBindingForOperation(String operationName) {
        return this.format("No <http:operation> or <soap:operation> for operation {0}", operationName);
    }

    public String msgMultipleBindingsForOperation(String operationName) {
        return this.format("Operation {0} has multiple binding elements", operationName);
    }

    public String msgNoBinding(QName bindingName) {
        return this.format("No <http:binding> or <soap:binding> for binding {0}", bindingName);
    }

    public String msgMultipleBindings(QName bindingName) {
        return this.format("Binding {0} has multiple binding elements", bindingName);
    }

    public String msgNoHTTPBindingForPort(String name) {
        return this.format("No HTTP binding for port: {0}", name);
    }

    public String msgNoSOAPBindingForPort(String name) {
        return this.format("No SOAP binding for port: {0}", name);
    }

    public String msgNoAddressForPort(String portName) {
        return this.format("No address for port {0}", portName);
    }

    public String msgMultipleAddressesForPort(String portName) {
        return this.format("Multiple addresses for port {0}", portName);
    }

    public Throwable msgSOAPBodyDoesNotContainAllRequiredParts() {
        String s = this.format("SOAP body does not contain all required parts");
        return new IllegalArgumentException(s);
    }

    public Throwable msgSoapHeaderMustBeAnElement(Node headerNode) {
        String s = this.format("SOAP header must be an element: {0}.", headerNode);
        return new IllegalArgumentException(s);
    }

    public Throwable msgSoapHeaderMissingRequiredElement(QName elementType) {
        String s = this.format("SOAP header missing required element: {0}.", elementType);
        return new IllegalArgumentException(s);
    }

    public Throwable msgUndefinedFault(QName serviceName, String portName, String opname, QName faultName) {
        String s = this.format("Undefined fault: service {0} port {1} operation {2} fault {3}.", serviceName, portName, opname, faultName);
        return new IllegalArgumentException(s);
    }

    public Throwable msgOdeMessagePartMissingRequiredElement(QName serviceName, String portName, String opname, QName elementName) {
        String s = this.format("Message part is missing required element: service {0} port {1} operation {2} element {3}.", serviceName, portName, opname, elementName);
        return new IllegalArgumentException(s);
    }

    public Throwable msgBindingDefinesNonElementDocListParts() {
        String s = this.format("Binding defines non-element document literal part(s)");
        return new IllegalArgumentException(s);
    }

    public Throwable msgUnexpectedElementInSOAPBody(QName name, QName elementName) {
        String s = this.format("Unexpected element in SOAP body: message {0} element {1}.", name, elementName);
        return new IllegalArgumentException(s);
    }

    public Throwable msgSOAPBodyDoesNotContainRequiredPart(String name) {
        String s = this.format("SOAP body does not contain required part: {0}.", name);
        return new IllegalArgumentException(s);
    }

    public Throwable msgSoapBodyDoesNotContainExpectedPartWrapper(QName serviceName, String portName, QName rpcWrapQName) {
        String s = this.format("SOAP body does not contain expected part wrapper: service {0} port {1} wrapper {2}", serviceName, portName, rpcWrapQName);
        return new IllegalArgumentException(s);
    }

    public Throwable msgSoapHeaderReferencesUnkownPart(String part) {
        String s = this.format("SOAP header references unknown part: {0}.", part);
        return new IllegalArgumentException(s);
    }

    public Throwable msgOdeMessageExpected() {
        String s = this.format("Message expected!");
        return new IllegalArgumentException(s);
    }

    public Throwable msgOdeMessageMissingRequiredPart(String partName) {
        String s = this.format("Message is missing required part: {0}", partName);
        return new IllegalArgumentException(s);
    }

    public Throwable msgUnexpectedBindingClass(Class passedClass) {
        String s = this.format("Unexpected class: {0}! Must be passed javax.wsdl.extensions.soap.SOAPBinding or javax.wsdl.extensions.http.HTTPBinding", passedClass);
        return new IllegalArgumentException(s);
    }

    public String msgPortDefinitionNotFound(QName serviceName, String portName) {
        return this.format("Port definition not found: service {0} port {1}.", serviceName, portName);
    }

    public Throwable msgBindingOperationNotFound(QName serviceName, String portName, String name) {
        String s = this.format("Binding operation not found: service {0} port {1} name {2}.", serviceName, portName, name);
        return new IllegalArgumentException(s);
    }

    public Throwable msgBindingInputNotFound(QName serviceName, String portName, String name) {
        String s = this.format("Binding input not found: service {0} port {1} name {2}.", serviceName, portName, name);
        return new IllegalArgumentException(s);
    }

    public Throwable msgBindingOutputNotFound(QName serviceName, String portName, String name) {
        String s = this.format("Binding output not found: service {0} port {1} name {2}.", serviceName, portName, name);
        return new IllegalArgumentException(s);
    }

    public String msgServiceDefinitionNotFound(QName serviceName) {
        return this.format("Service definition not found: {0}.", serviceName);
    }

    public String msgBindingNotFound(String portName) {
        return this.format("Binding not found: port {0}.", portName);
    }

    public String msgMultipleMimeContent() {
        return this.format("Multiple MIME Contents found!");
    }
}

