/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.bpel2svg;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.jboss.soa.bpel.bpel2svg.SVGImageTransformer;
import org.jboss.soa.bpel.bpel2svg.SVGToPNGImageTransformer;
import org.jboss.soa.bpel.bpel2svg.SVGToSVGImageTransformer;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.LayoutManager;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.BPELImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.SVGImpl;

public class BPEL2SVGUtil {
    public static final String PNG_IMAGE = "png";
    public static final String SVG_IMAGE = "svg";
    private static Map<String, SVGImageTransformer> m_transformers = new HashMap<String, SVGImageTransformer>();

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: BPEL2SVGUtil <bpelFile> <outputFile> [ <transformType> ]");
            System.err.println("(transformerType values are: png,svg)");
            System.exit(1);
        }
        SVGImageTransformer transformer = null;
        if (args.length == 3) {
            transformer = BPEL2SVGUtil.getTransformer(args[2]);
            if (transformer == null) {
                System.err.println("Unknown transformerType '" + args[2] + "', valid values are: " + PNG_IMAGE + "," + SVG_IMAGE);
                System.exit(1);
            }
        } else {
            transformer = BPEL2SVGUtil.getTransformer(SVG_IMAGE);
        }
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            FileOutputStream os = new FileOutputStream(args[1]);
            SVGInterface svg = BPEL2SVGUtil.generate(fis);
            ActivityInterface seq = svg.getActivityAtLineNumber(53);
            ActivityInterface recv = svg.getActivityAtLineNumber(61);
            ActivityInterface assign = svg.getActivityAtLineNumber(64);
            transformer.transform(svg, os);
            fis.close();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generate(InputStream is, OutputStream os, SVGImageTransformer transformer) throws IOException {
        SVGImpl svg = BPEL2SVGUtil.generateSVGImpl(is);
        if (transformer == null) {
            String str = svg.getHeaders() + svg.generateSVGString();
            os.write(str.getBytes());
        } else {
            transformer.transform(svg, os);
        }
    }

    public static SVGInterface generate(InputStream is) throws IOException {
        return BPEL2SVGUtil.generateSVGImpl(is);
    }

    protected static SVGImpl generateSVGImpl(InputStream is) throws IOException {
        byte[] b = new byte[is.available()];
        is.read(b);
        BPELImpl bpel = new BPELImpl();
        OMElement bpelStr = bpel.load(new String(b));
        bpel.processBpelString(bpelStr);
        LayoutManager layoutManager = BPEL2SVGFactory.getInstance().getLayoutManager();
        layoutManager.setVerticalLayout(true);
        layoutManager.setYSpacing(20);
        layoutManager.setYSpacing(50);
        layoutManager.layoutSVG(bpel.getRootActivity());
        SVGImpl svg = new SVGImpl();
        svg.setRootActivity(bpel.getRootActivity());
        return svg;
    }

    public static SVGImageTransformer getTransformer(String code) {
        return m_transformers.get(code);
    }

    static {
        m_transformers.put(SVG_IMAGE, new SVGToSVGImageTransformer());
        m_transformers.put(PNG_IMAGE, new SVGToPNGImageTransformer());
    }
}

