/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.riftsaw;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.DeploymentRef;
import org.riftsaw.engine.Fault;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.component.bpel.BPELLogger;
import org.switchyard.component.bpel.BPELMessages;
import org.switchyard.component.bpel.exchange.BPELExchangeHandler;
import org.switchyard.component.bpel.riftsaw.SwitchYardPropertyFunction;
import org.switchyard.component.bpel.riftsaw.WSDLHelper;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.config.model.implementation.bpel.BPELComponentImplementationModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RiftsawBPELExchangeHandler
extends BaseServiceHandler
implements BPELExchangeHandler {
    private static final int UNDEPLOY_DELAY = 10000;
    private static final String VFS_SCHEME = "vfs";
    private static final String DEPLOY_XML = "deploy.xml";
    private static final Logger LOG = Logger.getLogger(RiftsawBPELExchangeHandler.class);
    private BPELEngine _engine = null;
    private QName _serviceName = null;
    private QName _processName = null;
    private Definition _wsdl = null;
    private PortType _portType = null;
    private long _undeployDelay = 10000L;
    private BPELComponentImplementationModel _model;
    private Properties _config;
    private static Map<QName, QName> _serviceRefToCompositeMap = new HashMap<QName, QName>();
    private static Map<QName, DeploymentRef> _deployed = new HashMap<QName, DeploymentRef>();
    private static Timer _timer = new Timer();
    private static List<QName> _undeployed = new ArrayList<QName>();

    public RiftsawBPELExchangeHandler(ServiceDomain domain) {
        super(domain);
    }

    @Override
    public void init(QName qname, BPELComponentImplementationModel model, String intf, BPELEngine engine, Properties config) {
        this._engine = engine;
        this._wsdl = WSDLHelper.getWSDLDefinition(intf);
        this._portType = WSDLHelper.getPortType(intf, this._wsdl);
        this._serviceName = qname;
        this._processName = model.getProcessQName();
        this._model = model;
        this._config = config;
    }

    protected String getDeploymentName() throws Exception {
        String ret = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(DEPLOY_XML);
        if (url != null) {
            String urlpath = url.toString();
            int fileSeparatorIndex = (urlpath = urlpath.substring(0, urlpath.length() - DEPLOY_XML.length() - 1)).lastIndexOf(47);
            if (fileSeparatorIndex != -1) {
                ret = urlpath.substring(fileSeparatorIndex + 1);
                int suffixIndex = ret.lastIndexOf(46);
                if (suffixIndex != -1) {
                    ret = ret.substring(0, suffixIndex);
                }
            } else {
                BPELLogger.ROOT_LOGGER.failedToObtainDeploymentNameFromURL(urlpath);
            }
        } else {
            BPELLogger.ROOT_LOGGER.unableToLocateDeploymentDescriptorDeployXmlToDeriveDeploymentName();
        }
        if (LOG.isDebugEnabled()) {
            BPELLogger.ROOT_LOGGER.deploymentNameIs(ret);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getDeployment() throws Exception {
        boolean approvedDeployment;
        File ret = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(DEPLOY_XML);
        int jarIndex = url.toString().indexOf(".jar");
        int warIndex = url.toString().indexOf(".war");
        boolean bl = approvedDeployment = url.toString().indexOf(".ear") != -1 || url.toString().indexOf(".war") != -1 || url.toString().indexOf(".jar") != -1;
        if (approvedDeployment) {
            if (!url.getProtocol().equals(VFS_SCHEME)) throw BPELMessages.MESSAGES.unknownDeploymentEnvironment();
            try {
                VirtualFile vfile = VFS.getChild((URI)url.toURI());
                List children = vfile.getParent().getChildrenRecursively();
                for (VirtualFile child : children) {
                    child.getPhysicalFile();
                }
                ret = vfile.getPhysicalFile().getParentFile();
            }
            catch (NoClassDefFoundError t) {
                BPELLogger.ROOT_LOGGER.unableToResolveTheDeploymentURL(t);
            }
        } else {
            ret = new File(url.toURI()).getParentFile();
        }
        if (!LOG.isDebugEnabled()) return ret;
        LOG.debug((Object)("Deployment=" + ret));
        return ret;
    }

    protected void doStart() {
        QName compositeName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("START: " + this._serviceName));
        }
        if (this._config.containsKey("bpel.undeploy.delay")) {
            try {
                this._undeployDelay = Long.parseLong(this._config.getProperty("bpel.undeploy.delay"));
            }
            catch (Exception e) {
                BPELLogger.ROOT_LOGGER.unableToTransformPropertyValueIntoUndeployDelayValue(e, this._config.getProperty("bpel.undeploy.delay"));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Undeployment delay=" + this._undeployDelay + "ms"));
        }
        if (!_serviceRefToCompositeMap.containsValue(compositeName = this._model.getComponent().getComposite().getQName())) {
            try {
                File deployFile = this.getDeployment();
                DeploymentRef ref = this._engine.deploy(this.getDeploymentName(), deployFile);
                _deployed.put(this._serviceName, ref);
                _undeployed.remove(this._serviceName);
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
        }
        SwitchYardPropertyFunction.setPropertyResolver(this._processName, this._model.getModelConfiguration().getPropertyResolver());
        _serviceRefToCompositeMap.put(this._serviceName, compositeName);
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        Message message = exchange.getMessage();
        Node request = (Node)message.getContent(Node.class);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (Property p : exchange.getContext().getProperties()) {
            if (!p.hasLabel(EndpointLabel.SOAP.label())) continue;
            headers.put(p.getName(), p.getValue());
        }
        try {
            Operation operation = this._portType.getOperation(exchange.getContract().getProviderOperation().getName(), null, null);
            Element newreq = WSDLHelper.wrapRequestMessagePart((Element)request, operation);
            Element response = this._engine.invoke(this._serviceName, null, exchange.getContract().getProviderOperation().getName(), newreq, headers);
            if (exchange.getContract().getProviderOperation().getExchangePattern().equals((Object)ExchangePattern.IN_OUT)) {
                Message reply = exchange.createMessage();
                reply.setContent((Object)WSDLHelper.unwrapMessagePart(response));
                for (Map.Entry e : headers.entrySet()) {
                    exchange.getContext(reply).setProperty((String)e.getKey(), headers.get(e.getKey())).addLabels(new String[]{EndpointLabel.SOAP.label()});
                }
                exchange.send(reply);
            }
        }
        catch (Fault f) {
            SOAPFault fault = null;
            try {
                fault = SOAPFactory.newInstance().createFault("", f.getFaultName());
                Detail detail = fault.addDetail();
                Node cloned = detail.getOwnerDocument().importNode(WSDLHelper.unwrapMessagePart(f.getFaultMessage()), true);
                detail.appendChild(cloned);
            }
            catch (Exception e) {
                throw new HandlerException((Throwable)e);
            }
            Message msg = exchange.createMessage().setContent((Object)fault);
            exchange.sendFault(msg);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    protected void doStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("STOP: " + this._serviceName));
        }
        _undeployed.add(this._serviceName);
        if (this._undeployDelay > 0L) {
            _timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RiftsawBPELExchangeHandler.this.undeploy();
                }
            }, this._undeployDelay);
        } else {
            this.undeploy();
        }
        _serviceRefToCompositeMap.remove(this._serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy() {
        List<QName> list = _undeployed;
        synchronized (list) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking whether to undeploy '" + this._serviceName + "'"));
            }
            if (_undeployed.contains(this._serviceName) && _deployed.containsKey(this._serviceName)) {
                DeploymentRef ref = _deployed.get(this._serviceName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Undeploy '" + this._serviceName + "' with ref: " + ref));
                }
                if (ref != null) {
                    try {
                        this._engine.undeploy(ref);
                    }
                    catch (Exception e) {
                        BPELLogger.ROOT_LOGGER.failedToUndeploy(this._serviceName, e);
                    }
                }
                _deployed.remove(this._serviceName);
                _undeployed.remove(this._serviceName);
            }
            SwitchYardPropertyFunction.removePropertyResolver(this._processName);
        }
    }

    public void destroy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DESTROY: " + this._serviceName));
        }
    }
}

