/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.LayoutManager;
import org.wso2.carbon.bpel.ui.bpel2svg.Link;
import org.wso2.carbon.bpel.ui.bpel2svg.ProcessInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class ProcessImpl
extends ActivityImpl
implements ProcessInterface {
    private Log log = LogFactory.getLog(ActivityImpl.class);

    public ProcessImpl(String token) {
        super(token);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.endIconHeight = this.startIconHeight;
        this.endIconWidth = this.startIconWidth;
    }

    public ProcessImpl(OMElement omElement) {
        super(omElement);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.endIconHeight = this.startIconHeight;
        this.endIconWidth = this.startIconWidth;
    }

    public ProcessImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.endIconHeight = this.startIconHeight;
        this.endIconWidth = this.startIconWidth;
    }

    @Override
    public String getId() {
        return this.getName() + "-Process";
    }

    @Override
    public Element getSVGString(SVGDocument document) {
        LayoutManager layoutManager = BPEL2SVGFactory.getInstance().getLayoutManager();
        this.doc = (SVGDocument)this.dom.createDocument(this.svgNS, "svg", null);
        this.root = this.doc.getDocumentElement();
        this.root.setAttributeNS(null, "height", "1000");
        this.root.appendChild(this.getDefs(this.doc));
        this.root.appendChild(this.getBoxDefinition(this.doc));
        this.root.appendChild(this.getImageDefinition(this.doc));
        this.root.appendChild(this.getSubActivitiesSVGString(this.doc));
        this.root.appendChild(this.getEndImageDefinition(this.doc));
        this.root.appendChild(this.getArrows(this.doc));
        return this.root;
    }

    @Override
    public SVGDocument getSVGDocument() {
        LayoutManager layoutManager = BPEL2SVGFactory.getInstance().getLayoutManager();
        this.doc = (SVGDocument)this.dom.createDocument(this.svgNS, "svg", null);
        this.root = this.doc.getDocumentElement();
        int iHeight = this.getDimensions().getHeight();
        int iWidth = this.getDimensions().getWidth();
        this.root.setAttributeNS(null, "height", Integer.toString(iHeight));
        this.root.setAttributeNS(null, "width", Integer.toString(iWidth));
        this.root.appendChild(this.getDefs(this.doc));
        this.root.appendChild(this.getBoxDefinition(this.doc));
        this.root.appendChild(this.getImageDefinition(this.doc));
        this.root.appendChild(this.getSubActivitiesSVGString(this.doc));
        this.root.appendChild(this.getEndImageDefinition(this.doc));
        this.root.appendChild(this.getArrows(this.doc));
        this.root.appendChild(this.getLinkArrows(this.doc));
        return this.doc;
    }

    private String getSVGFileHeader() {
        StringBuffer svgSB = new StringBuffer();
        svgSB.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        svgSB.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1 Tiny//EN\"\n\t\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd\">\n");
        svgSB.append("<!-- Created with Oen ESB SVG Generator http://blogs.sun.com/toxophily/ -->\n");
        svgSB.append("<svg\n");
        svgSB.append("\txmlns=\"http://www.w3.org/2000/svg\"\n");
        svgSB.append("\txmlns:xlink=\"http://www.w3.org/1999/xlink\"\n");
        svgSB.append("\tversion=\"1.1\"  baseProfile=\"tiny\"\n");
        svgSB.append("\twidth=\"" + this.dimensions.getWidth() * 2 + "\"\n");
        svgSB.append("\theight=\"" + this.dimensions.getHeight() * 2 + "\"\n");
        svgSB.append("\tid=\"" + this.getId() + "\">\n");
        return svgSB.toString();
    }

    private String getSCGFileFooter() {
        return "</svg>\n";
    }

    protected Element getDefs(SVGDocument doc) {
        Element defs = doc.createElementNS("http://www.w3.org/2000/svg", "defs");
        defs.setAttributeNS(null, "id", "defs4");
        Element marker1 = doc.createElementNS("http://www.w3.org/2000/svg", "marker");
        marker1.setAttributeNS(null, "refX", "0");
        marker1.setAttributeNS(null, "refY", "0");
        marker1.setAttributeNS(null, "orient", "auto");
        marker1.setAttributeNS(null, "id", "Arrow1Lend");
        marker1.setAttributeNS(null, "style", "overflow:visible");
        Element path1 = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        path1.setAttributeNS(null, "d", "M 0,0 L 5,-5 L -12.5,0 L 5,5 L 0,0 z");
        path1.setAttributeNS(null, "transform", "matrix(-0.8,0,0,-0.8,-10,0)");
        path1.setAttributeNS(null, "id", "path3166");
        path1.setAttributeNS(null, "style", "fill-rule:evenodd;stroke:#000000;stroke-width:1pt;marker-start:none");
        Element marker2 = doc.createElementNS("http://www.w3.org/2000/svg", "marker");
        marker2.setAttributeNS(null, "refX", "0");
        marker2.setAttributeNS(null, "refY", "0");
        marker2.setAttributeNS(null, "orient", "auto");
        marker2.setAttributeNS(null, "id", "Arrow1Mend");
        marker2.setAttributeNS(null, "style", "overflow:visible");
        Element path2 = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        path2.setAttributeNS(null, "d", "M 0,0 L 5,-5 L -12.5,0 L 5,5 L 0,0 z");
        path2.setAttributeNS(null, "transform", "matrix(-0.8,0,0,-0.8,-10,0)");
        path2.setAttributeNS(null, "id", "path3193");
        path2.setAttributeNS(null, "style", "fill-rule:evenodd;stroke:#000000;stroke-width:1pt;marker-start:none");
        Element linkMarker = doc.createElementNS("http://www.w3.org/2000/svg", "marker");
        linkMarker.setAttributeNS(null, "refX", "0");
        linkMarker.setAttributeNS(null, "refY", "0");
        linkMarker.setAttributeNS(null, "orient", "auto");
        linkMarker.setAttributeNS(null, "id", "LinkArrow");
        linkMarker.setAttributeNS(null, "style", "overflow:visible");
        Element linkPath = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        linkPath.setAttributeNS(null, "d", "M -11.5,0 L -7,-7.5 L -12.5,0 L -7,7.5 L -11.5,0 z");
        linkPath.setAttributeNS(null, "transform", "matrix(-0.8,0,0,-0.8,-10,0)");
        linkPath.setAttributeNS(null, "id", "linkPath");
        linkPath.setAttributeNS(null, "style", "fill-rule:evenodd;stroke:#000000;stroke-width:1pt;marker-start:none");
        Element linearGradient = doc.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        linearGradient.setAttributeNS(null, "id", "orange_red");
        linearGradient.setAttributeNS(null, "x1", "0%");
        linearGradient.setAttributeNS(null, "y1", "0%");
        linearGradient.setAttributeNS(null, "x2", "0%");
        linearGradient.setAttributeNS(null, "y2", "100%");
        Element stop1 = doc.createElementNS("http://www.w3.org/2000/svg", "stop");
        stop1.setAttributeNS(null, "offset", "0%");
        stop1.setAttributeNS(null, "style", "stop-color:rgb(255,255,255);stop-opacity:1");
        Element stop2 = doc.createElementNS("http://www.w3.org/2000/svg", "stop");
        stop2.setAttributeNS(null, "offset", "100%");
        stop2.setAttributeNS(null, "style", "stop-color:rgb(0,0,255);stop-opacity:1");
        marker1.appendChild(path1);
        marker2.appendChild(path2);
        linkMarker.appendChild(linkPath);
        defs.appendChild(marker1);
        defs.appendChild(marker2);
        defs.appendChild(linkMarker);
        linearGradient.appendChild(stop1);
        linearGradient.appendChild(stop2);
        defs.appendChild(linearGradient);
        return defs;
    }

    protected Element getArrows(SVGDocument doc) {
        Element group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        if (this.subActivities != null) {
            ActivityInterface endActivity;
            ActivityInterface startActivity = (ActivityInterface)this.subActivities.get(0);
            startActivity = endActivity = (ActivityInterface)this.subActivities.get(this.subActivities.size() - 1);
            SVGCoordinates exitCoords = this.getExitArrowCoords();
            group.appendChild(this.getArrowDefinition(doc, exitCoords.getXLeft(), exitCoords.getYTop(), startActivity.getEntryArrowCoords().getXLeft(), startActivity.getEntryArrowCoords().getYTop(), this.name, startActivity, endActivity));
            SVGCoordinates entryCoords = this.getEndEntryArrowCoords();
            group.appendChild(this.getArrowDefinition(doc, endActivity.getExitArrowCoords().getXLeft(), endActivity.getExitArrowCoords().getYTop(), entryCoords.getXLeft(), entryCoords.getYTop(), this.name, startActivity, endActivity));
        }
        return group;
    }

    private Element getLinkArrows(SVGDocument doc) {
        Element group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        if (this.links != null && !this.links.isEmpty()) {
            Set linksSet = this.links.entrySet();
            for (Map.Entry link : linksSet) {
                ActivityInterface startActivity = ((Link)link.getValue()).getSource();
                ActivityInterface endActivity = ((Link)link.getValue()).getTarget();
                String linkName = (String)link.getKey();
                group.appendChild(this.drawLink(doc, startActivity.getExitArrowCoords().getXLeft(), startActivity.getExitArrowCoords().getYTop(), endActivity.getEntryArrowCoords().getXLeft(), endActivity.getEntryArrowCoords().getYTop(), startActivity.getStartIconWidth(), (String)link.getKey(), linkName));
            }
        }
        return group;
    }

    private Element drawLink(SVGDocument doc, int startX, int startY, int endX, int endY, int startIconWidth, String id, String linkName) {
        Element path = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        int firstBend = 20;
        if (this.layoutManager.isVerticalLayout()) {
            if (startY < endY) {
                path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + startX + "," + (startY + firstBend) + " L " + startX + "," + (startY + firstBend) + " L " + endX + "," + (startY + firstBend) + " L " + endX + "," + endY);
            } else if (startX > endX) {
                path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + startX + "," + (startY + firstBend) + " L " + (startX - (startIconWidth / 2 + firstBend)) + "," + (startY + firstBend) + " L " + (startX - (startIconWidth / 2 + firstBend)) + "," + (endY - firstBend) + " L " + endX + "," + (endY - firstBend) + " L " + endX + "," + endY);
            } else {
                path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + startX + "," + (startY + firstBend) + " L " + (startX + (startIconWidth / 2 + firstBend)) + "," + (startY + firstBend) + " L " + (startX + (startIconWidth / 2 + firstBend)) + "," + (endY - firstBend) + " L " + endX + "," + (endY - firstBend) + " L " + endX + "," + endY);
            }
        } else {
            path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + endY + " L " + endX + "," + endY);
        }
        path.setAttributeNS(null, "id", id);
        path.setAttributeNS(null, "style", this.getLinkArrowStyle());
        path.setAttributeNS("xlink", "title", linkName);
        path.setAttributeNS(null, "onmouseover", "this.style.opacity=1;this.filters.alpha.opacity=100");
        path.setAttributeNS(null, "onmouseout", "this.style.opacity=" + this.getIconOpacity(this.getState()) + ";this.filters.alpha.opacity=100");
        return path;
    }

    @Override
    public String getEndTag() {
        return "/process";
    }

    @Override
    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            this.dimensions = new SVGDimension(width, height);
            SVGDimension subActivityDim = null;
            ActivityInterface activity = null;
            Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
            try {
                while (itr.hasNext()) {
                    activity = itr.next();
                    subActivityDim = activity.getDimensions();
                    if (subActivityDim.getWidth() > width) {
                        width += subActivityDim.getWidth();
                    }
                    height += subActivityDim.getHeight();
                }
            }
            catch (NoSuchElementException e) {
                this.log.error((Object)"Invalid Element access", (Throwable)e);
            }
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing() * 2 + this.getStartIconHeight() + this.getEndIconHeight());
            this.layoutManager.setSvgHeight(height);
            this.layoutManager.setSvgWidth(width);
            if (!this.layoutManager.isVerticalLayout()) {
                this.switchDimensionsToHorizontal();
            }
        }
        return this.dimensions;
    }

    @Override
    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        int endXLeft = centreOfMyLayout - this.getEndIconWidth() / 2;
        int endYTop = startYTop + this.dimensions.getHeight() - this.getEndIconHeight() - this.getYSpacing() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop + this.getStartIconHeight() + this.getYSpacing() / 2;
        int childXLeft = startXLeft + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    private void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        int endXLeft = startXLeft + this.dimensions.getWidth() - this.getEndIconWidth() - this.getYSpacing() / 2;
        int endYTop = centreOfMyLayout - this.getEndIconHeight() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childXLeft = xLeft + this.getStartIconWidth() + this.getYSpacing() / 2;
        int childYTop = startYTop + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    @Override
    public SVGCoordinates getExitArrowCoords() {
        int xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
        int yTop = this.getStartIconYTop() + this.getStartIconHeight();
        if (!this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getEndEntryArrowCoords() {
        int xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
        int yTop = this.getEndIconYTop();
        if (!this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    @Override
    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    @Override
    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

