/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.hibernate;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.dao.jpa.hibernate.JpaOperatorImpl;
import org.apache.ode.dao.jpa.store.ConfStoreDAOConnectionImpl;
import org.apache.ode.dao.store.ConfStoreDAOConnection;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;

public class ConfStoreDAOConnectionFactoryImpl
implements ConfStoreDAOConnectionFactory {
    static final Log __log = LogFactory.getLog(ConfStoreDAOConnectionFactoryImpl.class);
    EntityManagerFactory _emf;
    TransactionManager _txm;
    DataSource _ds;
    JpaOperator _operator = new JpaOperatorImpl();

    @Override
    public void init(Properties odeConfig, TransactionManager txm, Object env) {
        this._txm = txm;
        this._ds = (DataSource)env;
        Map emfProperties = HibernateUtil.buildConfig("dao.factory.store.", odeConfig, this._txm, this._ds);
        this._emf = Persistence.createEntityManagerFactory((String)"ode-store", (Map)emfProperties);
    }

    @Override
    public ConfStoreDAOConnection getConnection() {
        ThreadLocal<ConfStoreDAOConnectionImpl> currentConnection = ConfStoreDAOConnectionImpl.getThreadLocal();
        ConfStoreDAOConnectionImpl conn = currentConnection.get();
        if (conn != null && HibernateUtil.isOpen(conn)) {
            return conn;
        }
        EntityManager em = this._emf.createEntityManager();
        conn = new ConfStoreDAOConnectionImpl(em, this._txm, this._operator);
        currentConnection.set(conn);
        return conn;
    }

    @Override
    public void shutdown() {
        this._emf.close();
    }
}

