/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.MultiKeyMap;

public class InternPool {
    private static MultiKeyMap cachedValues = MultiKeyMap.decorate((AbstractHashedMap)new LRUMap());
    private static Set<String> cachedBlocks = Collections.synchronizedSet(new HashSet());

    protected InternPool() {
    }

    public static void runBlock(InternableBlock block) {
        String processId = InternPool.getProcessId();
        cachedBlocks.add(processId);
        block.run();
        cachedBlocks.remove(processId);
        InternPool.clearAll(processId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object intern(Object key, Object value) {
        String processId = InternPool.getProcessId();
        if (!cachedBlocks.contains(processId)) {
            return value;
        }
        MultiKeyMap multiKeyMap = cachedValues;
        synchronized (multiKeyMap) {
            Object intern;
            ArrayList<Object> values = (ArrayList<Object>)cachedValues.get((Object)processId, key);
            if (values == null) {
                values = new ArrayList<Object>();
                cachedValues.put((Object)processId, key, values);
            }
            if (values.contains(value)) {
                intern = values.get(values.indexOf(value));
            } else {
                intern = value;
                values.add(intern);
            }
            return intern;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearAll(String processId) {
        MultiKeyMap multiKeyMap = cachedValues;
        synchronized (multiKeyMap) {
            cachedValues.remove((Object)processId);
        }
    }

    private static String getProcessId() {
        return String.valueOf(Thread.currentThread().getId());
    }

    public static interface InternableBlock {
        public void run();
    }
}

