/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsd.CapturingXMLEntityResolver;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.ode.utils.xsd.XsdMessages;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSModel;
import org.w3c.dom.ls.LSInput;

public class XSUtils {
    private static final Log __log = LogFactory.getLog(XSUtils.class);
    private static final XsdMessages __msgs = MessageBundle.getMessages(XsdMessages.class);

    public static Map<URI, byte[]> captureSchema(URI systemURI, byte[] schemaData, XMLEntityResolver resolver) throws XsdException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("captureSchema(URI,Text,...): systemURI=" + systemURI));
        }
        DOMInputImpl input = new DOMInputImpl();
        input.setSystemId(systemURI.toString());
        input.setByteStream((InputStream)new ByteArrayInputStream(schemaData));
        Map<URI, byte[]> ret = XSUtils.captureSchema((LSInput)input, resolver);
        ret.put(systemURI, schemaData);
        return ret;
    }

    private static Map<URI, byte[]> captureSchema(LSInput input, XMLEntityResolver resolver) throws XsdException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("captureSchema(LSInput,...): input.systemId=" + input.getSystemId()));
        }
        HashMap<URI, byte[]> captured = new HashMap<URI, byte[]>();
        if (resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        CapturingXMLEntityResolver cr = new CapturingXMLEntityResolver(captured, resolver);
        XMLSchemaLoader schemaLoader = new XMLSchemaLoader();
        schemaLoader.setEntityResolver((XMLEntityResolver)cr);
        schemaLoader.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        LoggingXmlErrorHandler eh = new LoggingXmlErrorHandler(__log);
        schemaLoader.setErrorHandler((XMLErrorHandler)eh);
        XSModel model = schemaLoader.load(input);
        if (model == null) {
            List<XMLParseException> errors = eh.getErrors();
            if (errors.size() != 0) {
                __log.error((Object)("captureSchema: XMLParseException(s) in " + input));
                XsdException ex = null;
                for (XMLParseException xpe : errors) {
                    ex = new XsdException(ex, xpe.getMessage(), xpe.getLineNumber(), xpe.getColumnNumber(), xpe.getLiteralSystemId());
                }
                throw ex;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("captureSchema: NULL model (unknown error) for " + input.getSystemId()));
            }
        }
        return captured;
    }

    static class LoggingXmlErrorHandler
    implements XMLErrorHandler {
        private Log _log;
        private ArrayList<XMLParseException> _errors = new ArrayList();

        public LoggingXmlErrorHandler(Log log) {
            assert (log != null);
            this._log = log;
        }

        public List<XMLParseException> getErrors() {
            return this._errors;
        }

        public void warning(String domain, String key, XMLParseException ex) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("XSDErrorHandler.warning: domain=" + domain + ", key=" + key), (Throwable)ex);
            }
            if (ex != null) {
                this._errors.add(ex);
                throw ex;
            }
        }

        public void error(String domain, String key, XMLParseException ex) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("XSDErrorHandler.error: domain=" + domain + ", key=" + key), (Throwable)ex);
            }
            if (ex != null) {
                this._errors.add(ex);
                throw ex;
            }
            throw new XNIException("Unknown XSD error state; domain=" + domain + ", key=" + key);
        }

        public void fatalError(String domain, String key, XMLParseException ex) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("XSDErrorHandler.fatal: domain=" + domain + ", key=" + key), (Throwable)ex);
            }
            if (ex != null) {
                this._errors.add(ex);
                throw ex;
            }
            throw new XNIException("Unknown XSD error state; domain=" + domain + ", key=" + key);
        }
    }
}

