/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.Collections;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class MultiArgument
implements CommandlineFragment {
    private String _argName;
    private String _description;
    private String[] _values;
    private boolean _isOptional;

    public MultiArgument(String argName, String description, boolean optional) {
        this._argName = argName;
        this._description = description;
        this._isOptional = optional;
    }

    @Override
    public void reset() {
        this._values = null;
    }

    @Override
    public List<String> consume(List<String> s) throws CommandlineSyntaxException {
        if (s.size() == 0 && !this._isOptional) {
            throw new CommandlineSyntaxException("The " + this._argName + " argument is required.");
        }
        if (s.size() != 0) {
            this._values = s.toArray(new String[s.size()]);
            for (int i = 0; i < this._values.length; ++i) {
                if (!this._values[i].startsWith("-")) continue;
                throw new CommandlineSyntaxException("The flag " + this._values[i] + " was found where an argument <" + this._argName + "> was expected.");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    public boolean isSet() {
        return this._values != null;
    }

    public String[] getValues() {
        return this._values;
    }

    @Override
    public String getUsage() {
        return "<" + this._argName + "_1> ... <" + this._argName + "_n>";
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

