/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public abstract class ServiceLoader {
    public static Object loadService(String propertyName, String defaultFactory) {
        Object factory = ServiceLoader.loadFromServices(propertyName, null);
        if (factory == null) {
            factory = ServiceLoader.loadFromPropertiesFile(propertyName, null);
        }
        if (factory == null) {
            factory = ServiceLoader.loadFromSystemProperty(propertyName, defaultFactory);
        }
        return factory;
    }

    public static Object loadFromServices(String propertyName, String defaultFactory) {
        String filename;
        Object factory = null;
        String factoryName = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream inStream = loader.getResourceAsStream(filename = "META-INF/services/" + propertyName);
        if (inStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                factoryName = br.readLine();
                br.close();
                if (factoryName != null) {
                    Class<?> factoryClass = loader.loadClass(factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory);
        }
        return factory;
    }

    public static Object loadFromSystemProperty(String propertyName, String defaultFactory) {
        Object factory = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        PropertyAccessAction action = new PropertyAccessAction(propertyName);
        String factoryName = (String)AccessController.doPrivileged(action);
        if (factoryName != null) {
            try {
                Class<?> factoryClass = loader.loadClass(factoryName);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory);
        }
        return factory;
    }

    public static Object loadFromPropertiesFile(String propertyName, String defaultFactory) {
        Object factory = null;
        String factoryName = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        PrivilegedAction action = new PropertyAccessAction("java.home");
        String javaHome = (String)AccessController.doPrivileged(action);
        File jaxmFile = new File(javaHome + "/lib/service-loader.properties");
        if (jaxmFile.exists()) {
            try {
                action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
                factoryName = jaxmProperties.getProperty(propertyName);
                if (factoryName != null) {
                    Class<?> factoryClass = loader.loadClass(factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory);
        }
        return factory;
    }

    private static Object loadDefault(String defaultFactory) {
        Object factory = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (defaultFactory != null) {
            try {
                Class<?> factoryClass = loader.loadClass(defaultFactory);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load: " + defaultFactory, t);
            }
        }
        return factory;
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        public Object run() {
            try {
                FileInputStream inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                return props;
            }
            catch (IOException ex) {
                throw new SecurityException("Cannot load properties: " + this.filename, ex);
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

