/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.FlowGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.CompositeActivity;
import org.apache.ode.bpel.compiler.bom.FlowActivity;
import org.apache.ode.bpel.compiler.bom.Link;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OFlow;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

class FlowGenerator
extends DefaultActivityGenerator {
    private static final FlowGeneratorMessages __cmsgs = MessageBundle.getMessages(FlowGeneratorMessages.class);

    FlowGenerator() {
    }

    @Override
    public void compile(OActivity output, Activity src) {
        FlowActivity flowAct = (FlowActivity)src;
        OFlow oflow = (OFlow)output;
        this.compileLinkDecls(oflow, flowAct);
        this.compileChildren(oflow, flowAct);
        for (OLink olink : oflow.localLinks) {
            try {
                if (olink.source == null) {
                    throw new CompilationException(__cmsgs.errLinkMissingSourceActivity(olink.name).setSource(flowAct));
                }
            }
            catch (CompilationException ce) {
                this._context.recoveredFromError(src, ce);
            }
            try {
                if (olink.target != null) continue;
                throw new CompilationException(__cmsgs.errLinkMissingTargetActivity(olink.name).setSource(flowAct));
            }
            catch (CompilationException ce) {
                this._context.recoveredFromError(src, ce);
            }
        }
    }

    @Override
    public OActivity newInstance(Activity src) {
        return new OFlow(this._context.getOProcess(), this._context.getCurrent());
    }

    private void compileLinkDecls(OFlow oflow, FlowActivity flowAct) {
        for (Link link : flowAct.getLinks()) {
            OLink olink = new OLink(this._context.getOProcess());
            olink.name = link.getLinkName();
            this.declareLink(oflow, olink);
        }
    }

    private void declareLink(OFlow oflow, final OLink olink) throws CompilationException {
        if (CollectionsX.find_if(oflow.localLinks, new MemberOfFunction<OLink>(){

            @Override
            public boolean isMember(OLink o) {
                return o.name.equals(olink.name);
            }
        }) != null) {
            throw new CompilationException(__cmsgs.errDuplicateLinkDecl(olink.name));
        }
        olink.declaringFlow = oflow;
        oflow.localLinks.add(olink);
    }

    protected void compileChildren(OFlow dest, CompositeActivity src) {
        for (Activity child : src.getActivities()) {
            try {
                OActivity compiledChild = this._context.compile(child);
                dest.parallelActivities.add(compiledChild);
            }
            catch (CompilationException ce) {
                this._context.recoveredFromError(child, ce);
            }
        }
    }
}

