/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.hibernate;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.bpel.BpelDAOConnectionImpl;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.dao.jpa.hibernate.JpaOperatorImpl;

public class BpelDAOConnectionFactoryImpl
implements BpelDAOConnectionFactory {
    static final Log __log = LogFactory.getLog(BpelDAOConnectionFactoryImpl.class);
    JpaOperator _operator = new JpaOperatorImpl();
    EntityManagerFactory _emf;
    TransactionManager _txm;
    DataSource _ds;

    @Override
    public void init(Properties odeConfig, TransactionManager txm, Object env) {
        this._txm = txm;
        this._ds = (DataSource)env;
        Map emfProperties = HibernateUtil.buildConfig("dao.factory.", odeConfig, this._txm, this._ds);
        this._emf = Persistence.createEntityManagerFactory((String)"ode-bpel", (Map)emfProperties);
        odeConfig.put("ode.emf", this._emf);
    }

    @Override
    public BpelDAOConnection getConnection() {
        ThreadLocal<BpelDAOConnectionImpl> currentConnection = BpelDAOConnectionImpl.getThreadLocal();
        BpelDAOConnectionImpl conn = currentConnection.get();
        if (conn != null && HibernateUtil.isOpen(conn)) {
            return conn;
        }
        EntityManager em = this._emf.createEntityManager();
        conn = new BpelDAOConnectionImpl(em, this._txm, this._operator);
        currentConnection.set(conn);
        return conn;
    }

    @Override
    public void shutdown() {
        this._emf.close();
    }
}

