/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.dbutil;

import java.io.File;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.scheduler.SchedulerDAOConnectionFactory;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.il.dbutil.DatabaseConnectionManager;
import org.apache.ode.il.dbutil.EmbeddedDatabase;
import org.apache.ode.il.dbutil.H2Database;
import org.apache.ode.il.dbutil.Messages;
import org.apache.ode.utils.LoggingInterceptor;

public class Database {
    private static final Log __log = LogFactory.getLog(Database.class);
    private static final Log __logSql = LogFactory.getLog((String)"org.apache.ode.sql");
    private static final Messages __msgs = Messages.getMessages(Messages.class);
    private OdeConfigProperties _odeConfig;
    private boolean _started;
    private DatabaseConnectionManager _connectionManager;
    private TransactionManager _txm;
    private DataSource _datasource;
    private File _workRoot;
    private boolean _needShutdown;
    private EmbeddedDatabase _embeddedDB;

    public Database(OdeConfigProperties props) {
        if (props == null) {
            throw new NullPointerException("Must provide a configuration.");
        }
        this._odeConfig = props;
    }

    public void setWorkRoot(File workRoot) {
        this._workRoot = workRoot;
    }

    public void setTransactionManager(TransactionManager txm) {
        this._txm = txm;
    }

    public synchronized void start() throws DatabaseConfigException {
        if (this._started) {
            return;
        }
        this._needShutdown = false;
        this._datasource = null;
        this._connectionManager = null;
        this.initDataSource();
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (!this._started) {
            return;
        }
        if (this._connectionManager != null) {
            try {
                __log.debug((Object)"Stopping connection manager");
                this._connectionManager.shutdown();
            }
            catch (Throwable t) {
                __log.warn((Object)("Exception while stopping connection manager: " + t.getMessage()));
            }
            finally {
                this._connectionManager = null;
            }
        }
        if (this._needShutdown) {
            __log.debug((Object)"shutting down database.");
            this._embeddedDB.shutdown();
        }
        this._needShutdown = false;
        this._datasource = null;
        this._started = false;
    }

    public DataSource getDataSource() {
        DataSource ds = __logSql.isDebugEnabled() ? LoggingInterceptor.createLoggingDS(this._datasource, __logSql) : this._datasource;
        return ds;
    }

    private void initDataSource() throws DatabaseConfigException {
        switch (this._odeConfig.getDbMode()) {
            case EXTERNAL: {
                this.initExternalDb();
                break;
            }
            case EMBEDDED: {
                this.initEmbeddedDb();
                break;
            }
            case INTERNAL: {
                this.initInternalDb();
                break;
            }
        }
    }

    private void initExternalDb() throws DatabaseConfigException {
        try {
            this._datasource = (DataSource)this.lookupInJndi(this._odeConfig.getDbDataSource());
            __log.debug((Object)__msgs.msgOdeUsingExternalDb(this._odeConfig.getDbDataSource()));
        }
        catch (Exception ex) {
            String msg = __msgs.msgOdeInitExternalDbFailed(this._odeConfig.getDbDataSource());
            __log.error((Object)msg, (Throwable)ex);
            throw new DatabaseConfigException(msg, ex);
        }
    }

    private void initInternalDb() throws DatabaseConfigException {
        __log.debug(__msgs.msgOdeUsingInternalDb(this._odeConfig.getDbIntenralJdbcUrl(), this._odeConfig.getDbInternalJdbcDriverClass()));
        this.initInternalDb(this._odeConfig.getDbIntenralJdbcUrl(), this._odeConfig.getDbInternalJdbcDriverClass(), this._odeConfig.getDbInternalUserName(), this._odeConfig.getDbInternalPassword());
    }

    private void initInternalDb(String url, String driverClass, String username, String password) throws DatabaseConfigException {
        this._connectionManager = new DatabaseConnectionManager(this._txm, this._odeConfig);
        this._connectionManager.init(url, driverClass, username, password);
        this._datasource = this._connectionManager.getDataSource();
    }

    private void initEmbeddedDb() throws DatabaseConfigException {
        switch (this._odeConfig.getDbEmbeddedType()) {
            case H2: {
                this._embeddedDB = new H2Database();
                break;
            }
            default: {
                this._embeddedDB = new H2Database();
            }
        }
        this._embeddedDB.init(this._workRoot, this._odeConfig, this._txm);
        this._datasource = this._embeddedDB.getDataSource();
        this._needShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T lookupInJndi(String objName) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Object object;
            block11: {
                InitialContext ctx = null;
                try {
                    ctx = new InitialContext();
                    object = ctx.lookup(objName);
                    if (ctx == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Exception ex1) {
                            __log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                        }
                    }
                    throw throwable;
                }
                try {
                    ctx.close();
                }
                catch (Exception ex1) {
                    __log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                }
            }
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpelDAOConnectionFactory createDaoCF() throws DatabaseConfigException {
        String pClassName = this._odeConfig.getDAOConnectionFactory();
        __log.debug((Object)__msgs.msgOdeUsingDAOImpl(pClassName));
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            BpelDAOConnectionFactory cf;
            try {
                cf = (BpelDAOConnectionFactory)Class.forName(pClassName).newInstance();
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgDAOInstantiationFailed(pClassName);
                __log.error((Object)errmsg, (Throwable)ex);
                throw new DatabaseConfigException(errmsg, ex);
            }
            cf.init(this._odeConfig.getProperties(), this._txm, this.getDataSource());
            BpelDAOConnectionFactory bpelDAOConnectionFactory = cf;
            return bpelDAOConnectionFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfStoreDAOConnectionFactory createDaoStoreCF() throws DatabaseConfigException {
        String pClassName = this._odeConfig.getDAOConfStoreConnectionFactory();
        __log.debug((Object)__msgs.msgOdeUsingDAOImpl(pClassName));
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfStoreDAOConnectionFactory cf;
            try {
                cf = (ConfStoreDAOConnectionFactory)Class.forName(pClassName).newInstance();
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgDAOInstantiationFailed(pClassName);
                __log.error((Object)errmsg, (Throwable)ex);
                throw new DatabaseConfigException(errmsg, ex);
            }
            cf.init(this._odeConfig.getProperties(), this._txm, this.getDataSource());
            ConfStoreDAOConnectionFactory confStoreDAOConnectionFactory = cf;
            return confStoreDAOConnectionFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerDAOConnectionFactory createDaoSchedulerCF() throws DatabaseConfigException {
        String pClassName = this._odeConfig.getDAOConfScheduleConnectionFactory();
        __log.debug((Object)__msgs.msgOdeUsingDAOImpl(pClassName));
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SchedulerDAOConnectionFactory sdcf;
            try {
                sdcf = (SchedulerDAOConnectionFactory)Class.forName(pClassName).newInstance();
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgDAOInstantiationFailed(pClassName);
                __log.error((Object)errmsg, (Throwable)ex);
                throw new DatabaseConfigException(errmsg, ex);
            }
            sdcf.init(this._odeConfig.getProperties(), this._txm, this.getDataSource());
            SchedulerDAOConnectionFactory schedulerDAOConnectionFactory = sdcf;
            return schedulerDAOConnectionFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

