/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.scheduler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.dao.scheduler.JobDAO;

@Entity
@Table(name="ODE_JOB")
@NamedQueries(value={@NamedQuery(name="deleteJobs", query="DELETE FROM JobDAOImpl AS j WHERE j.jobId = :job AND j.nodeId = :node"), @NamedQuery(name="nodeIds", query="SELECT DISTINCT j.nodeId FROM JobDAOImpl AS j WHERE j.nodeId IS NOT NULL"), @NamedQuery(name="dequeueImmediate", query="SELECT j FROM JobDAOImpl AS j WHERE j.nodeId = :node AND j.scheduled = false AND j.timestamp < :time ORDER BY j.timestamp"), @NamedQuery(name="updateScheduled", query="UPDATE JobDAOImpl AS j SET j.scheduled = true WHERE j.jobId in (?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9, ?10)"), @NamedQuery(name="updateAssignToNode", query="UPDATE JobDAOImpl AS j SET j.nodeId = :node WHERE j.nodeId IS NULL AND j.scheduled = false AND mod(j.timestamp,:numNode) = :i AND j.timestamp < :maxTime"), @NamedQuery(name="updateReassign", query="UPDATE JobDAOImpl AS j SET j.nodeId = :newNode, j.scheduled = false WHERE j.nodeId = :oldNode")})
public class JobDAOImpl
implements JobDAO,
Serializable {
    private static final Log __log = LogFactory.getLog(JobDAOImpl.class);
    private String _jobId;
    private long _ts;
    private String _nodeId;
    private boolean _scheduled;
    private boolean _transacted;
    private boolean _persisted = true;
    private Scheduler.JobDetails _details = new Scheduler.JobDetails();

    @Override
    @Transient
    public Scheduler.JobDetails getDetails() {
        return this._details;
    }

    @Override
    @Id
    @Column(name="jobid", length=64)
    public String getJobId() {
        return this._jobId;
    }

    public void setJobId(String jobId) {
        this._jobId = jobId;
    }

    @Override
    @Transient
    public long getScheduledDate() {
        return this.getTimestamp();
    }

    @Override
    public void setScheduledDate(long scheduledDate) {
        this.setTimestamp(scheduledDate);
    }

    @Override
    @Transient
    public boolean isPersisted() {
        return this._persisted;
    }

    @Override
    @Column(name="transacted", nullable=false)
    public boolean isTransacted() {
        return this._transacted;
    }

    @Column(name="ts", nullable=false)
    public long getTimestamp() {
        return this._ts;
    }

    public void setTimestamp(long ts) {
        this._ts = ts;
    }

    @Column(name="nodeid", length=64)
    public String getNodeId() {
        return this._nodeId;
    }

    public void setNodeId(String nodeId) {
        this._nodeId = nodeId;
    }

    @Override
    @Column(name="scheduled", nullable=false)
    public boolean isScheduled() {
        return this._scheduled;
    }

    @Override
    public void setScheduled(boolean scheduled) {
        this._scheduled = scheduled;
    }

    public void setTransacted(boolean transacted) {
        this._transacted = transacted;
    }

    public void setPersisted(boolean persisted) {
        this._persisted = persisted;
    }

    public void setDetails(Scheduler.JobDetails details) {
        this._details = details;
    }

    @Column(name="instanceId")
    public long getInstanceId() {
        return this._details.instanceId == null ? 0L : this._details.instanceId;
    }

    public void setInstanceId(long instanceId) {
        this._details.instanceId = instanceId;
    }

    @Column(name="mexId")
    public String getMexId() {
        return this._details.mexId;
    }

    public void setMexId(String mexId) {
        this._details.mexId = mexId;
    }

    @Column(name="processId")
    public String getProcessId() {
        return this._details.processId;
    }

    public void setProcessId(String processId) {
        this._details.processId = processId;
    }

    @Column(name="type")
    public String getType() {
        return this._details.type;
    }

    public void setType(String type) {
        this._details.type = type != null ? type : "";
    }

    @Column(name="channel")
    public String getChannel() {
        return this._details.channel;
    }

    public void setChannel(String channel) {
        this._details.channel = channel;
    }

    @Column(name="correlatorId")
    public String getCorrelatorId() {
        return this._details.correlatorId;
    }

    public void setCorrelatorId(String correlatorId) {
        this._details.correlatorId = correlatorId;
    }

    @Column(name="correlationKeySet")
    public String getCorrelationKeySet() {
        return this._details.getCorrelationKeySet().toCanonicalString();
    }

    public void setCorrelationKeySet(String correlationKey) {
        this._details.setCorrelationKeySet(new CorrelationKeySet(correlationKey));
    }

    @Column(name="retryCount")
    public int getRetryCount() {
        return this._details.retryCount == null ? 0 : this._details.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this._details.retryCount = retryCount;
    }

    @Column(name="inMem")
    public boolean isInMem() {
        return this._details.inMem == null ? false : this._details.inMem;
    }

    public void setInMem(boolean inMem) {
        this._details.inMem = inMem;
    }

    @Lob
    @Column(name="detailsExt")
    public byte[] getDetailsExt() {
        if (this._details.detailsExt != null && this._details.detailsExt.size() > 0) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(this._details.detailsExt);
                os.close();
                return bos.toByteArray();
            }
            catch (Exception e) {
                __log.error((Object)"Error in getDetailsExt ", (Throwable)e);
            }
        }
        return null;
    }

    public void setDetailsExt(byte[] detailsExt) {
        if (detailsExt != null && detailsExt.length > 0) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(detailsExt);
                ObjectInputStream is = new ObjectInputStream(bis);
                this._details.detailsExt = (Map)is.readObject();
                is.close();
            }
            catch (Exception e) {
                __log.error((Object)"Error in setDetailsExt ", (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("JobId: " + this._jobId);
        builder.append(",nodeId: " + this._nodeId);
        builder.append(",scheduled: " + this._scheduled);
        builder.append(",transacted: " + this._transacted);
        builder.append(",ts: " + this._ts);
        builder.append(",channel: " + this._details.getChannel());
        builder.append(",instaceId : " + this._details.getInstanceId());
        builder.append(",type: " + (Object)((Object)this._details.getType()));
        builder.append(",retrycount: " + this._details.getRetryCount());
        builder.append("]");
        return builder.toString();
    }
}

