/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.utils.msg.MessageBundle;

public class Messages
extends MessageBundle {
    String msgBarProcessLoadErr() {
        return this.format("Unable to load compiled BPEL process.");
    }

    String msgProcessDeployed(Object dir, QName processId) {
        return this.format("Process {1} deployed from \"{1}\".", dir, processId);
    }

    String msgDbError() {
        return this.format("A database error prevented the operation from succeeding.");
    }

    String msgInstanceNotFound(Long pid) {
        return this.format("The instance \"{0}\" was not found in the database.", pid);
    }

    String msgUnknownEPR(String epr) {
        return this.format("Unkown EPR: {0}", epr);
    }

    String msgProcessUndeployed(QName process) {
        return this.format("Process {0} has been undeployed.", process);
    }

    String msgProcessUndeployFailed(QName process) {
        return this.format("Failed to undeploy process {0}! Check database for consistency!", process);
    }

    String msgProcessNotFound(QName pid) {
        return this.format("Process {0} not found. ", pid);
    }

    String msgProcessNotActive(QName processId) {
        return this.format("Process {0} is not active. ", processId);
    }

    String msgProcessLoadError(QName processId) {
        return this.format("Process {0}, could not be loaded. ", processId);
    }

    String msgDeployFailDescriptorURIInvalid(URI dduri) {
        return this.format("Deployment failure: invalid deployment descriptor URI \"{0}\" ", dduri);
    }

    String msgDeployFailDescriptorInvalid(URI dduri) {
        return this.format("Deployment failure: invalid/malformed deployment descriptor at \"{0}\"", dduri);
    }

    String msgDeployFailDescriptorIOError(URI dduri) {
        return this.format("Deployment failure: IO error reading deployment descriptor at \"{0}\"", dduri);
    }

    String msgDDPartnerLinkNotFound(String partnerLinkName) {
        return this.format("Partner link declared in process deployment descriptor could not be found in process definition: {0}", partnerLinkName);
    }

    String msgDDPartnerRoleNotFound(String partnerLinkName) {
        return this.format("Role 'partnerRole' declared in process deployment descriptor isn't defined in process definition for partner link : {0}", partnerLinkName);
    }

    String msgDDMyRoleNotFound(String partnerLinkName) {
        return this.format("Role 'myRole' declared in process deployment descriptor isn't defined in process definition for partner link : {0}", partnerLinkName);
    }

    String msgDDNoInitiliazePartnerRole(String partnerLinkName) {
        return this.format("Partner link {0} is defined in process as initializePartnerRole=no, its partner role endpoint can't be initialized by deployment descriptor.", partnerLinkName);
    }

    String msgProcessDeployErrAlreadyDeployed(QName processId) {
        return this.format("The process could not be deployed; another process is already deployed as {0}!", processId);
    }

    String msgScheduledJobReferencesUnknownInstance(Long iid) {
        return this.format("Received a scheduled job event for unknown instance {0}", iid);
    }

    String msgReschedulingJobForInactiveProcess(QName processId, String jobId, Date rescheduled) {
        return this.format("Received a scheduled job event for inactive process {0}; rescheduling job {1} for {2}", processId, jobId, rescheduled);
    }

    String msgProcessActivationError(QName pid) {
        return this.format("Error activating process {0}", pid);
    }

    String msgOperationInterrupted() {
        return this.format("Operation was interrupted.");
    }

    String msgProcessActivated(QName pid) {
        return this.format("Activated process {0}.", pid);
    }

    String msgServerStarted() {
        return this.format("BPEL Server Started.");
    }

    String msgServerStopped() {
        return this.format("BPEL Server Stopped.");
    }

    String msgUndefinedServicePort(QName service, String port) {
        return this.format("The service name and port defined in your deployment descriptor couldn't be found in any WSDL document: {0} {1}.", service, port);
    }

    String msgInterceptorAborted(String mexId, String interceptor, String msg) {
        return this.format("Message exchange {0} aborted by interceptor {1}: {2}", mexId, interceptor, msg);
    }

    String msgMyRoleRoutingFailure(String messageExchangeId) {
        return this.format("Unable to route message exchange {0}, EPR was not specified and the target my-role could not be inferred.", messageExchangeId);
    }

    String msgPropertyAliasReturnedNullSet(String alias, String variable) {
        return this.format("msgPropertyAliasReturnedNullSet: {0} {1}", alias, variable);
    }

    String msgUnknownOperation(String operationName, QName portType) {
        return this.format("Unknown operation \"{0}\" for port type \"{1}\".", operationName, portType);
    }

    public String msgDeployStarting(File deploymentUnitDirectory) {
        return this.format("Starting deployment of processes from directory \"{0}\". ", deploymentUnitDirectory);
    }

    public String msgDeployFailed(QName name, File deploymentUnitDirectory) {
        return this.format("Deployment of process \"{0}\" from \"{1}\" failed.", name, deploymentUnitDirectory);
    }

    public String msgDeployRollback(File deploymentUnitDirectory) {
        return this.format("Deployment of processes from \"{0}\" failed, rolling back. ", deploymentUnitDirectory);
    }

    public String msgOdeInitHibernatePropertiesNotFound(File expected) {
        return this.format("Hibernate configuration file \"{0}\" not found, defaults will be used.", expected);
    }

    public String msgOdeInitHibernateErrorReadingHibernateProperties(File hibernatePropFile) {
        return this.format("Error reading Hibernate properties file \"{0}\".", hibernatePropFile);
    }

    public String msgOdeInitHibernateDialectDetectFailed() {
        return this.format("Error detecting database dialect; Hibernate DAO could not be started.");
    }

    public String msgDeployFailDuplicateDU(String name) {
        return this.format("Deploy failed; Deployment Unit \"{0}\" already deployed!", name);
    }

    public String msgDeployFailDuplicatePID(QName processId, String name) {
        return this.format("Deploy failed; process \"{0}\" already deployed!", processId);
    }

    public String msgDeployFailedProcessNotFound(QName pid, String du) {
        return this.format("Deploy failed; process \"{0}\" not found in deployment unit \"{1}\".", pid, du);
    }

    public String msgDeployFailCompileErrors(CompilationException ce) {
        if (ce != null) {
            return this.format("Deploy failed; {0}", ce.getMessage());
        }
        return this.format("Deploy failed; BPEL compilation errors.");
    }
}

