/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xquery10.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompilationErrorListener;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xquery10.o.OXQuery10ExpressionBPEL20;
import org.apache.ode.bpel.o.OConstantVarType;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.apache.xml.utils.XMLChar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XQuery10ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Log __log = LogFactory.getLog(XQuery10ExpressionCompilerImpl.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XQuery10ExpressionCompilerImpl(String bpelNS) {
        this._bpelNS = bpelNS;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.elang.xquery10.runtime.XQuery10ExpressionRuntime");
        TransformerFactoryImpl trsf = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)trsf);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xe = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener(xe);
    }

    @Override
    public OExpression compileJoinCondition(Object source) throws CompilationException {
        return this._compile((Expression)source, true);
    }

    @Override
    public OExpression compile(Object source) throws CompilationException {
        return this._compile((Expression)source, false);
    }

    @Override
    public OLValueExpression compileLValue(Object source) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)source, false);
    }

    private OExpression _compile(Expression xquery, boolean isJoinCondition) throws CompilationException {
        OXQuery10ExpressionBPEL20 oexp = new OXQuery10ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, isJoinCondition);
        oexp.namespaceCtx = xquery.getNamespaceContext();
        this.doJaxpCompile(oexp, xquery);
        return oexp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJaxpCompile(OXQuery10ExpressionBPEL20 out, Expression source) throws CompilationException {
        Node node = source.getExpression();
        if (node == null) {
            throw new CompilationException(this.__msgs.errEmptyExpression(source.getURI(), new QName(source.getElement().getNamespaceURI(), source.getElement().getNodeName())));
        }
        if (node.getNodeType() != 3 && node.getNodeType() != 1 && node.getNodeType() != 4) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString(node)));
        }
        String xqueryStr = DOMUtils.domToString(node);
        if ((xqueryStr = xqueryStr.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString(node), "empty string"));
        }
        try {
            QName typeQName;
            SaxonXQDataSource xqds = new SaxonXQDataSource(new Configuration());
            XQConnection xqconn = xqds.getConnection();
            __log.debug((Object)("Compiling expression " + xqueryStr));
            Configuration configuration = ((SaxonXQConnection)xqconn).getConfiguration();
            configuration.setHostLanguage(51);
            XQStaticContext staticContext = xqconn.getStaticContext();
            JaxpFunctionResolver funcResolver = new JaxpFunctionResolver(this._compilerContext, out, source.getNamespaceContext(), this._bpelNS);
            JaxpVariableResolver variableResolver = new JaxpVariableResolver(this._compilerContext, out);
            XQueryDeclarations declarations = new XQueryDeclarations();
            NSContext nsContext = source.getNamespaceContext();
            Set<String> prefixes = nsContext.getPrefixes();
            if (!nsContext.getUriSet().contains(Namespaces.ODE_EXTENSION_NS)) {
                nsContext.register("ode", Namespaces.ODE_EXTENSION_NS);
            }
            for (String prefix : prefixes) {
                String uri = nsContext.getNamespaceURI(prefix);
                staticContext.declareNamespace(prefix, uri);
                if ("".equals(prefix)) {
                    declarations.declareDefaultElementNamespace(uri);
                    continue;
                }
                if ("bpws".equals(prefix)) {
                    declarations.declareNamespace("bpws", "java:org.apache.ode.bpel.elang.xquery10.compiler.XQuery10BpelFunctions");
                    continue;
                }
                declarations.declareNamespace(prefix, uri);
            }
            declarations.declareVariable(this.getQName(nsContext, Namespaces.ODE_EXTENSION_NS, "pid"), this.getQName(nsContext, Namespaces.XML_SCHEMA, "integer"));
            configuration.setSchemaValidationMode(4);
            List<OScope.Variable> variables = this._compilerContext.getAccessibleVariables();
            HashMap<QName, QName> variableTypes = new HashMap<QName, QName>();
            for (String string : XQuery10ExpressionCompilerImpl.getVariableNames(xqueryStr)) {
                OScope.Variable variable = this.getVariable(variables, string);
                if (variable == null) continue;
                OVarType type = variable.type;
                QName nameQName = this.getNameQName(string);
                typeQName = this.getTypeQName(string, type);
                variableTypes.put(nameQName, typeQName);
                String prefix = typeQName.getPrefix();
                if (prefix == null || "".equals(prefix.trim())) {
                    prefix = this.getPrefixForUri(nsContext, typeQName.getNamespaceURI());
                }
                declarations.declareVariable(string);
            }
            out.xquery = declarations.toString() + xqueryStr;
            xqconn.setStaticContext(staticContext);
            XQPreparedExpression exp = xqconn.prepareExpression(out.xquery);
            node.setUserData("function-resolver", funcResolver, null);
            exp.bindItem(XQConstants.CONTEXT_ITEM, xqconn.createItemFromNode(node, xqconn.createNodeType()));
            for (QName variable : exp.getAllUnboundExternalVariables()) {
                typeQName = (QName)variableTypes.get(variable);
                Object value = variableResolver.resolveVariable(variable);
                if (typeQName == null) continue;
                if (value.getClass().getName().startsWith("java.lang")) {
                    exp.bindAtomicValue(variable, value.toString(), xqconn.createAtomicType(4));
                    continue;
                }
                if (value instanceof Node) {
                    exp.bindNode(variable, (Node)value, xqconn.createNodeType());
                    continue;
                }
                if (!(value instanceof NodeList)) continue;
                NodeList nodeList = (NodeList)value;
                ArrayList<Node> nodeArray = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    nodeArray.add(nodeList.item(i));
                }
                XQSequence sequence = xqconn.createSequence(nodeArray.iterator());
                exp.bindSequence(variable, sequence);
            }
            try {
                exp.executeQuery();
            }
            catch (XQException xQException) {
            }
            finally {
                if (node != null) {
                    node.setUserData("function-resolver", null, null);
                }
            }
        }
        catch (XQException xqe) {
            __log.debug((Object)xqe);
            __log.info((Object)("Couldn't validate properly expression " + xqueryStr));
            throw new CompilationException(this.__msgs.errXQuery10Syntax(xqueryStr, "Couldn't validate XQuery expression"));
        }
        catch (WrappedResolverException wre) {
            if (wre._compilationMsg != null) {
                throw new CompilationException(wre._compilationMsg, (Throwable)wre);
            }
            if (wre.getCause() instanceof CompilationException) {
                throw (CompilationException)wre.getCause();
            }
            throw wre;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    private String getQName(NSContext nsContext, String uri, String localPart) {
        String prefix = this.getPrefixForUri(nsContext, uri);
        return prefix == null ? localPart : prefix + ":" + localPart;
    }

    private String getPrefixForUri(NSContext nsContext, String uri) {
        Set<String> prefixes = nsContext.getPrefixes();
        for (String prefix : prefixes) {
            String anUri = nsContext.getNamespaceURI(prefix);
            if (anUri == null || !anUri.equals(uri)) continue;
            return prefix;
        }
        return null;
    }

    protected static Collection<String> getVariableNames(String xquery) {
        LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
        int index = xquery.indexOf("$");
        while (index != -1) {
            StringBuilder variableName = new StringBuilder();
            ++index;
            while (index < xquery.length() && XMLChar.isNCName((int)xquery.charAt(index))) {
                variableName.append(xquery.charAt(index++));
            }
            variableNames.add(variableName.toString());
            xquery = xquery.substring(index);
            index = xquery.indexOf("$");
        }
        return variableNames;
    }

    private OScope.Variable getVariable(List<OScope.Variable> variables, String variableName) {
        String declaredVariable = this.getVariableDeclaredName(variableName);
        for (OScope.Variable variable : variables) {
            if (!variable.name.equals(declaredVariable)) continue;
            return variable;
        }
        return null;
    }

    private String getVariableDeclaredName(String variableReference) {
        int dotIndex = variableReference.indexOf(".");
        return dotIndex >= 0 ? variableReference.substring(0, dotIndex) : variableReference;
    }

    private String getVariablePartName(String variableReference) {
        int dotIndex = variableReference.indexOf(".");
        return dotIndex >= 0 ? variableReference.substring(dotIndex + 1) : "";
    }

    private QName getNameQName(String variableName) {
        String prefix = null;
        String localName = null;
        int colonIndex = variableName.indexOf(":");
        if (colonIndex >= 0) {
            prefix = variableName.substring(0, colonIndex);
            localName = variableName.substring(colonIndex + 1);
        } else {
            prefix = "";
            localName = variableName;
        }
        return new QName(prefix, localName);
    }

    private QName getTypeQName(String variableName, OVarType type) {
        QName typeQName = null;
        if (type instanceof OConstantVarType) {
            typeQName = new QName(Namespaces.XML_SCHEMA, "string", "xs");
        } else if (type instanceof OElementVarType) {
            typeQName = ((OElementVarType)type).elementType;
        } else if (type instanceof OMessageVarType) {
            OMessageVarType.Part part = ((OMessageVarType)type).parts.get(this.getVariablePartName(variableName));
            if (part != null) {
                typeQName = this.getTypeQName(variableName, part.type);
            }
        } else if (type instanceof OXsdTypeVarType) {
            typeQName = ((OXsdTypeVarType)type).xsdType;
        }
        return typeQName;
    }

    private static class XQueryDeclarations {
        StringBuffer declarations = new StringBuffer();

        public void declareVariable(String name, QName type) {
            this.declareVariable(name, type.getPrefix() + ":" + type.getLocalPart());
        }

        public void declareVariable(String name, String type) {
            this.declarations.append("declare variable ").append("$").append(name).append(" as ").append(type).append(" external ").append(";\n");
        }

        public void declareVariable(String name) {
            this.declarations.append("declare variable ").append("$").append(name).append(" external ").append(";\n");
        }

        public void declareNamespace(String prefix, String uri) {
            this.declarations.append("declare namespace ").append(prefix).append("=").append("\"" + uri + "\"").append(";\n");
        }

        public void declareDefaultElementNamespace(String uri) {
            this.declarations.append("declare default element namespace ").append("\"" + uri + "\"").append(";\n");
        }

        public String toString() {
            return this.declarations.toString();
        }
    }
}

