/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OWait;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannelListener;
import org.apache.ode.utils.xsd.Duration;

class WAIT
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(WAIT.class);

    WAIT(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
    }

    @Override
    public final void run() {
        Date dueDate = null;
        try {
            dueDate = this.getDueDate();
        }
        catch (FaultException e) {
            __log.error((Object)("Fault while calculating due date: " + e.getQName() + "; Reason: " + e.getMessage()));
            this._self.parent.completed(this.createFault(e.getQName(), this._self.o), CompensationHandler.emptySet());
            return;
        }
        catch (EvaluationException ee) {
            String msg = "Unexpected error evaluating wait condition.";
            __log.error((Object)msg, (Throwable)ee);
            this._self.parent.completed(this.createFault(this._self.o.getOwner().constants.qnSubLanguageExecutionFault, this._self.o), CompensationHandler.emptySet());
            return;
        }
        if (dueDate.getTime() > this.getBpelRuntimeContext().getCurrentEventDateTime().getTime()) {
            final TimerResponseChannel timerChannel = this.newChannel(TimerResponseChannel.class);
            this.getBpelRuntimeContext().registerTimer(timerChannel, dueDate);
            WAIT.object(false, new TimerResponseChannelListener(timerChannel){
                private static final long serialVersionUID = 3120518305645437327L;

                @Override
                public void onTimeout() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                }

                @Override
                public void onCancel() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(this._self.self){
                private static final long serialVersionUID = -2791243270691333946L;

                @Override
                public void terminate() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                    1.object(new TimerResponseChannelListener(timerChannel){
                        private static final long serialVersionUID = 677746737897792929L;

                        @Override
                        public void onTimeout() {
                        }

                        @Override
                        public void onCancel() {
                        }
                    });
                }
            }));
        } else {
            this._self.parent.completed(null, CompensationHandler.emptySet());
        }
    }

    protected Date getDueDate() throws FaultException, EvaluationException {
        OWait wait = (OWait)this._self.o;
        assert (wait.hasFor() || wait.hasUntil());
        EvaluationContext evalCtx = this.getEvaluationContext();
        Date dueDate = null;
        if (wait.hasFor()) {
            Calendar cal = Calendar.getInstance();
            System.out.println("CAL DATE : " + cal.getTime());
            Duration duration = this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDuration(wait.forExpression, evalCtx);
            duration.addTo(cal);
            System.out.println("DURATION SECONDS : " + duration.toString());
            dueDate = cal.getTime();
            System.out.println("DUE DATE : " + dueDate);
        } else if (wait.hasUntil()) {
            Calendar cal = this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDate(wait.untilExpression, evalCtx);
            dueDate = cal.getTime();
        } else {
            throw new AssertionError((Object)"Static checks failed to find bad WaitActivity!");
        }
        if (dueDate == null) {
            dueDate = new Date();
        }
        return dueDate;
    }
}

