/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.wstx;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.UserTransaction;
import com.arjuna.mw.wst11.common.CoordinationContextHelper;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.wstx.WebServiceTransaction;
import org.apache.ode.bpel.wstx.WebServiceTransactionType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtomicTransaction
implements WebServiceTransaction {
    private static final Log __log = LogFactory.getLog(AtomicTransaction.class);
    protected UserTransaction _tx;
    protected TxContext _txcontext;
    protected boolean _active = false;
    protected boolean _subordinate = false;

    private static synchronized void begin(UserTransaction tx) throws WrongStateException, SystemException {
        tx.begin();
    }

    @Override
    public void begin(Message bpelRequest) throws WrongStateException, SystemException {
        MessageImpl req = (MessageImpl)bpelRequest;
        this._subordinate = false;
        if (req._dao.getHeader() != null) {
            try {
                CoordinationContextType cct;
                NodeList cc = req._dao.getHeader().getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
                if (cc.getLength() > 0 && (cct = CoordinationContextHelper.deserialise((Element)((Element)cc.item(0).getFirstChild()))) != null) {
                    TxContextImple ctx = new TxContextImple(cct);
                    TransactionManager.getTransactionManager().resume((TxContext)ctx);
                    this._subordinate = true;
                }
            }
            catch (Exception e) {
                __log.error((Object)"Wrong coordination context. The transaction won't be subordinated.");
            }
        }
        this._tx = UserTransaction.getUserTransaction();
        if (this._subordinate && this._tx != null) {
            this._tx = UserTransaction.getUserTransaction().getUserSubordinateTransaction();
        }
        if (this._tx == null) {
            throw new SystemException("Distributed transaction has not been created. Check that JBoss XTS is runnning.");
        }
        try {
            AtomicTransaction.begin(this._tx);
        }
        catch (WrongStateException wse) {
            TransactionManager.getTransactionManager().suspend();
            this._tx = UserTransaction.getUserTransaction();
            AtomicTransaction.begin(this._tx);
        }
        this._txcontext = TransactionManager.getTransactionManager().currentTransaction();
        this._active = true;
    }

    @Override
    public void commit() throws SecurityException, UnknownTransactionException, SystemException, WrongStateException {
        this._active = false;
        try {
            this.resume();
            this._tx.commit();
        }
        catch (TransactionRolledBackException e) {
            __log.debug((Object)"Web service transaction was aborted.");
        }
        finally {
            this._tx = null;
            this._txcontext = null;
        }
    }

    @Override
    public void complete() throws UnknownTransactionException, SystemException, WrongStateException {
    }

    @Override
    public boolean isActive() {
        return this._tx != null && this._active;
    }

    @Override
    public boolean isSubordinate() {
        return this._subordinate;
    }

    @Override
    public String getTransactionIdentifier() {
        return this._tx.transactionIdentifier();
    }

    @Override
    public WebServiceTransactionType getType() {
        return WebServiceTransactionType.ATOMIC_TRANSACTION;
    }

    @Override
    public void rollback() throws SecurityException, UnknownTransactionException, SystemException, WrongStateException {
        this._active = false;
        try {
            this.resume();
            this._tx.rollback();
        }
        finally {
            this._tx = null;
            this._txcontext = null;
        }
    }

    @Override
    public void resume() throws UnknownTransactionException, SystemException {
        if (!this._txcontext.equals((Object)TransactionManager.getTransactionManager().currentTransaction())) {
            TransactionManager.getTransactionManager().resume(this._txcontext);
            this._tx = UserTransaction.getUserTransaction();
        }
    }

    @Override
    public void suspend() throws SystemException {
        this._txcontext = TransactionManager.getTransactionManager().suspend();
    }

    @Override
    public Element putCoordinationContext(Element headerElement) throws UnknownTransactionException, SystemException {
        this.resume();
        TxContextImple txContext = (TxContextImple)this._txcontext;
        CoordinationContextType ctx = txContext.context().getCoordinationContext();
        try {
            Document doc = headerElement.getOwnerDocument();
            Element coord = doc.createElementNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
            headerElement.appendChild(coord);
            CoordinationContextHelper.serialise((CoordinationContextType)ctx, (Element)headerElement);
            Element parent = doc.createElementNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
            Node tmp = headerElement.getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext").item(0);
            parent.appendChild(tmp.cloneNode(true));
            headerElement.replaceChild(parent, tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("Coordination context has not been added to the header.");
        }
        return headerElement;
    }
}

