/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class FlagWithArgument
implements CommandlineFragment {
    private String _name;
    private String _argName;
    private String _description;
    private String _arg;
    private boolean _isOptional = false;

    public FlagWithArgument(String name, String argName, String description, boolean optional) {
        this._name = "-" + name;
        this._description = description;
        this._argName = argName;
        this._isOptional = optional;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    public void setOptional(boolean o) {
        this._isOptional = o;
    }

    @Override
    public List<String> consume(List<String> s) throws CommandlineSyntaxException {
        if (!s.contains(this._name)) {
            if (!this._isOptional) {
                throw new CommandlineSyntaxException("The " + this._name + " flag with an argument is required.");
            }
            return s;
        }
        ArrayList<String> l = new ArrayList<String>(s);
        int idx = l.indexOf(this._name);
        if (idx == l.size() - 1 || l.get(idx + 1).startsWith("-")) {
            throw new CommandlineSyntaxException("The " + this._name + " flag requires an argument.");
        }
        this._arg = l.get(idx + 1);
        l.remove(idx + 1);
        l.remove(idx);
        return l;
    }

    @Override
    public void reset() {
        this._arg = null;
    }

    public boolean isSet() {
        return this._arg != null;
    }

    public String getValue() {
        return this._arg;
    }

    @Override
    public String getUsage() {
        return this._name + " <" + this._argName + ">";
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public boolean validate() {
        return true;
    }
}

