/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.MessageMetrics;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.ServiceOperation;
import org.switchyard.admin.Throttling;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.config.model.switchyard.ArtifactModel;

public final class PrintUtil {
    private static final String INTERFACE = "interface";
    private static final String TYPE = "type";
    private static final String APPLICATION = "application";
    private static final String COMPONENT_SERVICES = "componentServices";
    private static final String CONFIGURATION = "configuration";
    private static final String FROM = "from";
    private static final String IMPLEMENTATION = "implementation";
    private static final String IMPLEMENTATION_CONFIGURATION = "implementationConfiguration";
    private static final String GATEWAYS = "gateways";
    private static final String OPERATIONS = "operations";
    private static final String PROPERTIES = "properties";
    private static final String PROMOTED_REFERENCE = "promotedReference";
    private static final String PROMOTED_SERVICE = "promotedService";
    private static final String REFERENCES = "references";
    private static final String SERVICES = "services";
    private static final String STATE = "state";
    private static final String THROTTLING = "throttling";
    private static final String TO = "to";
    private static final String TRANSFORMERS = "transformers";
    private static final String ARTIFACTS = "artifacts";
    private static final String URL = "url";
    private static final String VALIDATORS = "validators";
    private static final String SUCCESS_COUNT = "successCount";
    private static final String FAULT_COUNT = "faultCount";
    private static final String TOTAL_COUNT = "totalCount";
    private static final String AVERAGE_TIME = "averageTime";
    private static final String MIN_TIME = "minTime";
    private static final String MAX_TIME = "maxTime";
    private static final String TOTAL_TIME = "totalTime";
    private static final String ENABLED = "enabled";
    private static final String MAX_REQUESTS = "maxRequests";
    private static final String TIME_PERIOD = "timePeriod";
    private static final List<String> INDENT = new ArrayList<String>();

    public static String printApplication(Application application) {
        StringBuffer applicationNode = new StringBuffer();
        int indentLevel = 0;
        applicationNode.append(PrintUtil.indent(indentLevel)).append(application.getName()).append(" = [\n");
        applicationNode.append(PrintUtil.indent(++indentLevel)).append(SERVICES).append(" = [\n");
        ++indentLevel;
        for (Service service : application.getServices()) {
            applicationNode.append(PrintUtil.printService(service, indentLevel));
        }
        applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        applicationNode.append(PrintUtil.indent(indentLevel)).append(REFERENCES).append(" = [\n");
        ++indentLevel;
        for (Reference reference : application.getReferences()) {
            applicationNode.append(PrintUtil.printReference(reference, indentLevel));
        }
        applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        applicationNode.append(PrintUtil.indent(indentLevel)).append(COMPONENT_SERVICES).append(" = [\n");
        ++indentLevel;
        for (ComponentService componentService : application.getComponentServices()) {
            applicationNode.append(PrintUtil.printComopnentService(componentService, indentLevel));
        }
        applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        applicationNode.append(PrintUtil.indent(indentLevel)).append(TRANSFORMERS).append(" = [\n");
        ++indentLevel;
        for (Transformer transformer : application.getTransformers()) {
            applicationNode.append(PrintUtil.indent(indentLevel)).append("[\n");
            applicationNode.append(PrintUtil.printTransformer(transformer, ++indentLevel));
            applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        if (application.getConfig().getArtifacts() != null) {
            applicationNode.append(PrintUtil.indent(indentLevel)).append(ARTIFACTS).append(" = [\n");
            ++indentLevel;
            for (ArtifactModel artifactModel : application.getConfig().getArtifacts().getArtifacts()) {
                applicationNode.append(PrintUtil.printArtifact(artifactModel, indentLevel));
            }
            applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        if (application.getValidators() != null) {
            applicationNode.append(PrintUtil.indent(indentLevel)).append(VALIDATORS).append(" = [\n");
            ++indentLevel;
            for (Validator validator : application.getValidators()) {
                applicationNode.append(PrintUtil.printValidator(validator, indentLevel));
            }
            applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        if (application.getProperties() != null) {
            applicationNode.append(PrintUtil.indent(indentLevel)).append(PROPERTIES).append(" = [\n");
            ++indentLevel;
            for (Map.Entry entry : application.getProperties().entrySet()) {
                applicationNode.append(PrintUtil.indent(indentLevel)).append((String)entry.getKey()).append(" = ").append((String)entry.getValue());
                applicationNode.append("\n");
            }
            applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        applicationNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return applicationNode.toString();
    }

    public static String printReference(Reference reference, int indentLevel) {
        String promotedReference;
        StringBuffer referenceNode = new StringBuffer();
        referenceNode.append(PrintUtil.indent(indentLevel)).append(reference.getName().toString()).append(" = [\n");
        referenceNode.append(PrintUtil.indent(++indentLevel)).append(APPLICATION).append(" = ").append(reference.getApplication().getName().toString());
        referenceNode.append("\n");
        String interfaceName = reference.getInterface();
        if (interfaceName != null) {
            referenceNode.append(PrintUtil.indent(indentLevel)).append(INTERFACE).append(" = ").append(interfaceName);
            referenceNode.append("\n");
        }
        if ((promotedReference = reference.getPromotedReference()) != null) {
            referenceNode.append(PrintUtil.indent(indentLevel)).append(PROMOTED_REFERENCE).append(" = ").append(promotedReference);
            referenceNode.append("\n");
        }
        referenceNode.append(PrintUtil.indent(indentLevel)).append(GATEWAYS).append(" = [\n");
        ++indentLevel;
        for (Binding gateway : reference.getGateways()) {
            referenceNode.append(PrintUtil.createGateway(gateway, indentLevel));
        }
        referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return referenceNode.toString();
    }

    public static String printService(Service service, int indentLevel) {
        ComponentService promotedService;
        StringBuffer serviceNode = new StringBuffer();
        serviceNode.append(PrintUtil.indent(indentLevel)).append(service.getName()).append(" = [\n");
        serviceNode.append(PrintUtil.indent(++indentLevel)).append(APPLICATION).append(" = ").append(service.getApplication().getName().toString());
        serviceNode.append("\n");
        String interfaceName = service.getInterface();
        if (interfaceName != null) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(INTERFACE).append(" = ").append(interfaceName);
            serviceNode.append("\n");
        }
        if ((promotedService = service.getPromotedService()) != null) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(PROMOTED_SERVICE).append(" = ").append(promotedService.getName().toString());
            serviceNode.append("\n");
        }
        serviceNode.append(PrintUtil.indent(indentLevel)).append(GATEWAYS).append(" = [\n");
        ++indentLevel;
        for (Binding gateway : service.getGateways()) {
            serviceNode.append(PrintUtil.createGateway(gateway, indentLevel));
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.printThrottlingTo(service.getThrottling(), indentLevel));
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return serviceNode.toString();
    }

    public static String printComopnentService(ComponentService service, int indentLevel) {
        String implementationConfiguration;
        String implementation;
        StringBuffer serviceNode = new StringBuffer();
        serviceNode.append(PrintUtil.indent(indentLevel)).append(service.getName()).append(" = [\n");
        serviceNode.append(PrintUtil.indent(++indentLevel)).append(APPLICATION).append(" = ").append(service.getApplication().getName().toString());
        serviceNode.append("\n");
        String interfaceName = service.getInterface();
        if (interfaceName != null) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(INTERFACE).append(" = ").append(interfaceName);
            serviceNode.append("\n");
        }
        if ((implementation = service.getImplementation()) != null) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(IMPLEMENTATION).append(" = ").append(implementation);
            serviceNode.append("\n");
        }
        if ((implementationConfiguration = service.getImplementationConfiguration()) != null) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(IMPLEMENTATION_CONFIGURATION).append(" = ").append(implementationConfiguration);
            serviceNode.append("\n");
        }
        serviceNode.append(PrintUtil.indent(indentLevel)).append(REFERENCES).append(" = [\n");
        ++indentLevel;
        for (ComponentReference reference : service.getReferences()) {
            serviceNode.append(PrintUtil.printComponentReference(reference, indentLevel));
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return serviceNode.toString();
    }

    public static String createGateway(Binding binding, int indentLevel) {
        StringBuffer gatewayNode = new StringBuffer();
        gatewayNode.append(PrintUtil.indent(indentLevel)).append(binding.getName()).append(" = [\n");
        ++indentLevel;
        if (binding.getType() != null) {
            gatewayNode.append(PrintUtil.indent(indentLevel)).append(TYPE).append(" = ").append(binding.getType());
            gatewayNode.append("\n");
        }
        if (binding.getConfiguration() != null) {
            gatewayNode.append(PrintUtil.indent(indentLevel)).append(CONFIGURATION).append(" = ").append(binding.getConfiguration());
            gatewayNode.append("\n");
        }
        gatewayNode.append(PrintUtil.indent(indentLevel)).append(STATE).append(" = ").append(binding.getState().toString());
        gatewayNode.append("\n");
        gatewayNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return gatewayNode.toString();
    }

    public static String printComponentReference(ComponentReference reference, int indentLevel) {
        StringBuffer referenceNode = new StringBuffer();
        referenceNode.append(PrintUtil.indent(indentLevel)).append(reference.getName().toString()).append(" = [\n");
        referenceNode.append(PrintUtil.indent(++indentLevel)).append(INTERFACE).append(" = ").append(reference.getInterface()).append("\n");
        referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return referenceNode.toString();
    }

    public static String printTransformer(Transformer transformation, int indentLevel) {
        StringBuffer transformationNode = new StringBuffer();
        if (transformation.getFrom() != null) {
            transformationNode.append(PrintUtil.indent(indentLevel)).append(FROM).append(" = ").append(transformation.getFrom().toString());
            transformationNode.append("\n");
        }
        if (transformation.getTo() != null) {
            transformationNode.append(PrintUtil.indent(indentLevel)).append(TO).append(" = ").append(transformation.getTo().toString());
            transformationNode.append("\n");
        }
        if (transformation.getType() != null) {
            transformationNode.append(PrintUtil.indent(indentLevel)).append(TYPE).append(" = ").append(transformation.getType());
            transformationNode.append("\n");
        }
        return transformationNode.toString();
    }

    public static String printArtifact(ArtifactModel artifact, int indentLevel) {
        StringBuffer artifactNode = new StringBuffer();
        artifactNode.append(PrintUtil.indent(indentLevel)).append(artifact.getName()).append(" = [\n");
        artifactNode.append(PrintUtil.indent(++indentLevel)).append(URL).append(" = ").append(artifact.getURL()).append("\n");
        --indentLevel;
        artifactNode.append("]\n");
        return artifactNode.toString();
    }

    public static String printValidator(Validator validator, int indentLevel) {
        StringBuffer validatorNode = new StringBuffer();
        validatorNode.append(PrintUtil.indent(indentLevel)).append(validator.getName().toString()).append(" = [\n");
        validatorNode.append(PrintUtil.indent(++indentLevel)).append(TYPE).append(" = ").append(validator.getType()).append("\n");
        validatorNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return validatorNode.toString();
    }

    public static String addMetricsToNode(MessageMetrics metrics, int indentLevel) {
        StringBuffer metricsNode = new StringBuffer();
        metricsNode.append(PrintUtil.indent(indentLevel)).append(SUCCESS_COUNT).append(" = ").append(metrics.getSuccessCount()).append("\n");
        metricsNode.append(PrintUtil.indent(indentLevel)).append(FAULT_COUNT).append(" = ").append(metrics.getFaultCount()).append("\n");
        metricsNode.append(PrintUtil.indent(indentLevel)).append(TOTAL_COUNT).append(" = ").append(metrics.getTotalCount()).append("\n");
        metricsNode.append(PrintUtil.indent(indentLevel)).append(AVERAGE_TIME).append(" = ").append(BigDecimal.valueOf(metrics.getAverageProcessingTime())).append("\n");
        metricsNode.append(PrintUtil.indent(indentLevel)).append(MIN_TIME).append(" = ").append(metrics.getMinProcessingTime()).append("\n");
        metricsNode.append(PrintUtil.indent(indentLevel)).append(MAX_TIME).append(" = ").append(metrics.getMaxProcessingTime()).append("\n");
        metricsNode.append(PrintUtil.indent(indentLevel)).append(TOTAL_TIME).append(" = ").append(metrics.getTotalProcessingTime()).append("\n");
        return metricsNode.toString();
    }

    public static String printReferenceMetrics(Reference reference, int indentLevel) {
        StringBuffer referenceNode = new StringBuffer();
        referenceNode.append(PrintUtil.indent(indentLevel)).append(reference.getName().toString()).append(" = [\n");
        referenceNode.append(PrintUtil.addMetricsToNode(reference.getMessageMetrics(), ++indentLevel));
        referenceNode.append(PrintUtil.indent(indentLevel)).append(GATEWAYS).append(" = [\n");
        ++indentLevel;
        for (Binding gateway : reference.getGateways()) {
            referenceNode.append(PrintUtil.indent(indentLevel)).append(gateway.getName()).append(" = [\n");
            referenceNode.append(PrintUtil.indent(++indentLevel)).append(TYPE).append(" = ").append(gateway.getType()).append("\n");
            referenceNode.append(PrintUtil.addMetricsToNode(gateway.getMessageMetrics(), indentLevel));
            referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        referenceNode.append(PrintUtil.indent(indentLevel)).append(OPERATIONS).append(" = [\n");
        ++indentLevel;
        for (ServiceOperation operation : reference.getServiceOperations()) {
            referenceNode.append(PrintUtil.indent(indentLevel)).append(operation.getName()).append(" = [\n");
            referenceNode.append(PrintUtil.addMetricsToNode(operation.getMessageMetrics(), ++indentLevel));
            referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        referenceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return referenceNode.toString();
    }

    public static String printServiceMetrics(Service service, int indentLevel) {
        StringBuffer serviceNode = new StringBuffer();
        serviceNode.append(PrintUtil.indent(indentLevel)).append(service.getName().toString()).append(" = [\n");
        serviceNode.append(PrintUtil.addMetricsToNode(service.getMessageMetrics(), ++indentLevel));
        serviceNode.append(PrintUtil.indent(indentLevel)).append(OPERATIONS).append(" = [\n");
        ++indentLevel;
        for (ServiceOperation operation : service.getPromotedService().getServiceOperations()) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(operation.getName()).append(" = [\n");
            serviceNode.append(PrintUtil.addMetricsToNode(operation.getMessageMetrics(), ++indentLevel));
            serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.indent(indentLevel)).append(REFERENCES).append(" = [\n");
        ++indentLevel;
        for (ComponentReference reference : service.getPromotedService().getReferences()) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(reference.getName()).append(" = [\n");
            serviceNode.append(PrintUtil.addMetricsToNode(reference.getMessageMetrics(), ++indentLevel));
            serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.indent(indentLevel)).append(GATEWAYS).append(" = [\n");
        ++indentLevel;
        for (Binding gateway : service.getGateways()) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(gateway.getName()).append(" = [\n");
            serviceNode.append(PrintUtil.indent(++indentLevel)).append(TYPE).append(" = ").append(gateway.getType()).append("\n");
            serviceNode.append(PrintUtil.addMetricsToNode(gateway.getMessageMetrics(), indentLevel));
            serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return serviceNode.toString();
    }

    public static String printComponentServiceMetrics(ComponentService componentService, int indentLevel) {
        StringBuffer serviceNode = new StringBuffer();
        serviceNode.append(PrintUtil.indent(indentLevel)).append(componentService.getName().toString()).append(" = [\n");
        serviceNode.append(PrintUtil.addMetricsToNode(componentService.getMessageMetrics(), ++indentLevel));
        serviceNode.append(PrintUtil.indent(indentLevel)).append(OPERATIONS).append(" = [\n");
        ++indentLevel;
        for (ServiceOperation operation : componentService.getServiceOperations()) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(operation.getName()).append(" = [\n");
            serviceNode.append(PrintUtil.addMetricsToNode(operation.getMessageMetrics(), ++indentLevel));
            serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.indent(indentLevel)).append(REFERENCES).append(" = [\n");
        ++indentLevel;
        for (ComponentReference reference : componentService.getReferences()) {
            serviceNode.append(PrintUtil.indent(indentLevel)).append(reference.getName()).append(" = [\n");
            serviceNode.append(PrintUtil.addMetricsToNode(reference.getMessageMetrics(), ++indentLevel));
            serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        }
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        serviceNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return serviceNode.toString();
    }

    public static String printThrottlingTo(Throttling throttling, int indentLevel) {
        if (throttling == null) {
            return "";
        }
        StringBuffer throttlingNode = new StringBuffer();
        throttlingNode.append(PrintUtil.indent(indentLevel)).append(THROTTLING).append(" = [\n");
        throttlingNode.append(PrintUtil.indent(++indentLevel)).append(ENABLED).append(" = ").append(throttling.isEnabled()).append("\n");
        throttlingNode.append(PrintUtil.indent(indentLevel)).append(MAX_REQUESTS).append(" = ").append(throttling.getMaxRequests()).append("\n");
        throttlingNode.append(PrintUtil.indent(indentLevel)).append(TIME_PERIOD).append(" = ").append(throttling.getTimePeriod()).append("\n");
        throttlingNode.append(PrintUtil.indent(--indentLevel)).append("]\n");
        return throttlingNode.toString();
    }

    private static synchronized String indent(int indentLevel) {
        while (INDENT.size() <= indentLevel) {
            StringBuffer indent = new StringBuffer();
            int size = 4 * INDENT.size();
            for (int i = 0; i <= size; ++i) {
                indent.append(' ');
            }
            INDENT.add(indent.toString());
        }
        return INDENT.get(indentLevel);
    }

    private PrintUtil() {
    }
}

