/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import javax.xml.namespace.QName;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;

@Command(scope="switchyard", name="gateway", description="Perform an operation on a gateway.")
public class GatewayCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="operation", description="Specifies the operation type [start | stop].", required=true)
    private OperationType _operation;
    @Argument(index=1, name="application", description="Specifies the name of the application containing the binding.", required=true)
    private String _application;
    @Argument(index=2, name="service", description="Specifies the name of the service containing the binding.", required=true)
    private String _service;
    @Argument(index=3, name="binding", description="Specifies the name of the binding.", required=true)
    private String _binding;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Binding binding;
        Application application = switchYard.getApplication(QName.valueOf(this._application));
        if (application == null) {
            System.err.println("Could not locate application: " + this._application);
            return null;
        }
        QName serviceName = QName.valueOf(this._service);
        Service service = application.getService(serviceName);
        if (service == null) {
            Reference reference = application.getReference(serviceName);
            if (reference == null) {
                System.err.println("Could not locate service or reference: " + this._service);
                return null;
            }
            binding = reference.getGateway(this._binding);
        } else {
            binding = service.getGateway(this._binding);
        }
        if (binding == null) {
            System.err.println("Could not locate binding: " + this._binding);
            return null;
        }
        switch (this._operation) {
            case start: {
                binding.start();
                break;
            }
            case stop: {
                binding.stop();
            }
        }
        return null;
    }

    public static enum OperationType {
        start,
        stop;

    }
}

