/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;
import org.switchyard.deploy.Component;

@Command(scope="switchyard", name="component-list", description="List switchyard components.")
public class ComponentList
extends OsgiCommandSupport {
    protected Object doExecute() throws Exception {
        Collection refs = this.getBundleContext().getServiceReferences(Component.class, "(switchyard.types=*)");
        if (refs != null) {
            TreeSet<String> types = new TreeSet<String>();
            for (ServiceReference ref : refs) {
                types.addAll(ComponentList.getTypes(ref.getProperty("switchyard.types")));
            }
            for (String type : types) {
                System.out.println(type);
            }
        }
        return null;
    }

    private static List<String> getTypes(Object ns) {
        if (ns == null) {
            throw new IllegalArgumentException("Component service does not have an associated switchyard.types property defined");
        }
        if (ns instanceof String[]) {
            return Arrays.asList((String[])ns);
        }
        if (ns instanceof URI) {
            return Collections.singletonList(ns.toString());
        }
        if (ns instanceof String) {
            return Collections.singletonList((String)ns);
        }
        if (ns instanceof Collection) {
            Collection col = (Collection)ns;
            ArrayList<String> types = new ArrayList<String>(col.size());
            for (Object o : col) {
                types.add(o.toString());
            }
            return types;
        }
        if (ns instanceof Object[]) {
            Object[] array = (Object[])ns;
            ArrayList<String> types = new ArrayList<String>(array.length);
            for (Object o : array) {
                types.add(o.toString());
            }
            return types;
        }
        throw new IllegalArgumentException("Component service has an associated switchyard.types property defined which can not be converted to an array of String");
    }
}

