/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;
import org.switchyard.deploy.karaf.PrintUtil;

@Command(scope="switchyard", name="read-application", description="Returns a details about a SwitchYard application deployed on the system.")
public class ReadApplicationCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="name", description="If specified, only details for the named application are returned.", multiValued=true)
    private List<String> _applicationNames;
    @Option(name="--regex", description="If specified, treat the application name(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Pattern pattern = this.compilePattern(this._applicationNames, this._regex);
        for (Application application : switchYard.getApplications()) {
            String applicationName = String.valueOf(application.getName());
            Matcher matcher = pattern.matcher(applicationName);
            if (!matcher.find()) continue;
            System.out.println(PrintUtil.printApplication(application));
        }
        return null;
    }
}

