/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;
import org.switchyard.deploy.karaf.PrintUtil;

@Command(scope="switchyard", name="show-metrics", description="Displays metrics for the specified service/reference/component service.")
public class ShowMetricsCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="type", description="Specifies the search type [service | reference | component | system].", required=true)
    private SearchType _type;
    @Argument(index=1, name="patterns", description="Specifies the search pattern to use.", multiValued=true)
    private List<String> _patterns;
    @Option(name="--regex", description="If specified, treat the pattern(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        if (this._type == SearchType.system) {
            System.out.println(PrintUtil.addMetricsToNode(switchYard.getMessageMetrics(), 1));
        } else {
            Pattern pattern = this.compilePattern(this._patterns, this._regex);
            for (Application application : switchYard.getApplications()) {
                this._type.printMetrics(pattern, application);
            }
        }
        return null;
    }

    public static enum SearchType {
        service{

            @Override
            public void printMetrics(Pattern pattern, Application application) {
                boolean printHeader = true;
                for (Service service : application.getServices()) {
                    Matcher matcher = pattern.matcher(service.getName().toString());
                    if (!matcher.find()) continue;
                    if (printHeader) {
                        System.out.println(application.getName() + " = [");
                        printHeader = false;
                    }
                    System.out.println(PrintUtil.printServiceMetrics(service, 1));
                }
                if (!printHeader) {
                    System.out.println("]");
                }
            }
        }
        ,
        reference{

            @Override
            public void printMetrics(Pattern pattern, Application application) {
                boolean printHeader = true;
                for (Reference reference : application.getReferences()) {
                    Matcher matcher = pattern.matcher(reference.getName().toString());
                    if (!matcher.find()) continue;
                    if (printHeader) {
                        System.out.println(application.getName() + " = [");
                        printHeader = false;
                    }
                    System.out.println(PrintUtil.printReferenceMetrics(reference, 1));
                }
                if (!printHeader) {
                    System.out.println("]");
                }
            }
        }
        ,
        component{

            @Override
            public void printMetrics(Pattern pattern, Application application) {
                boolean printHeader = true;
                for (ComponentService service : application.getComponentServices()) {
                    Matcher matcher = pattern.matcher(service.getName().toString());
                    if (!matcher.find()) continue;
                    if (printHeader) {
                        System.out.println(application.getName() + " = [");
                        printHeader = false;
                    }
                    System.out.println(PrintUtil.printComponentServiceMetrics(service, 1));
                }
                if (!printHeader) {
                    System.out.println("]");
                }
            }
        }
        ,
        system{

            @Override
            public void printMetrics(Pattern pattern, Application application) {
            }
        };


        public abstract void printMetrics(Pattern var1, Application var2);
    }
}

