/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.FactHandleFactory;
import org.kie.api.runtime.rule.EntryPoint;

public abstract class AbstractFactHandleFactory
implements FactHandleFactory {
    private AtomicInteger id;
    private AtomicLong counter;

    public AbstractFactHandleFactory() {
        this.id = new AtomicInteger(0);
        this.counter = new AtomicLong(0L);
    }

    public AbstractFactHandleFactory(int id, long counter) {
        this.id = new AtomicInteger(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public final InternalFactHandle newFactHandle(Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, EntryPoint wmEntryPoint) {
        return this.newFactHandle(this.id.incrementAndGet(), object, conf, workingMemory, wmEntryPoint);
    }

    public final InternalFactHandle newFactHandle(int id, Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, EntryPoint wmEntryPoint) {
        return this.newFactHandle(id, object, this.counter.incrementAndGet(), conf, workingMemory, wmEntryPoint);
    }

    @Override
    public abstract InternalFactHandle newFactHandle(int var1, Object var2, long var3, ObjectTypeConf var5, InternalWorkingMemory var6, EntryPoint var7);

    @Override
    public final void increaseFactHandleRecency(InternalFactHandle factHandle) {
        factHandle.setRecency(this.counter.incrementAndGet());
    }

    @Override
    public void destroyFactHandle(InternalFactHandle factHandle) {
        factHandle.invalidate();
    }

    @Override
    public abstract FactHandleFactory newInstance();

    @Override
    public AtomicInteger getAtomicId() {
        return this.id;
    }

    @Override
    public AtomicLong getAtomicRecency() {
        return this.counter;
    }

    @Override
    public int getId() {
        return this.id.get();
    }

    @Override
    public long getRecency() {
        return this.counter.get();
    }

    @Override
    public void clear(int id, long counter) {
        this.id = new AtomicInteger(id);
        this.counter = new AtomicLong(counter);
    }
}

