/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.kie.internal.utils.ClassLoaderUtil;

public class ProjectClassLoader
extends ClassLoader {
    private static final boolean CACHE_NON_EXISTING_CLASSES = true;
    private static final ClassNotFoundException dummyCFNE = new ClassNotFoundException("This is just a cached Exception. Disable non existing classes cache to see the actual one.");
    private Map<String, byte[]> store;
    private final Set<String> nonExistingClasses = new HashSet<String>();
    private ClassLoader droolsClassLoader;

    private ProjectClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static ClassLoader getClassLoader(ClassLoader[] classLoaders, Class<?> cls, boolean enableCache) {
        if (classLoaders == null || classLoaders.length == 0) {
            return cls == null ? ProjectClassLoader.createProjectClassLoader() : ProjectClassLoader.createProjectClassLoader(cls.getClassLoader());
        }
        if (classLoaders.length == 1) {
            ProjectClassLoader classLoader = ProjectClassLoader.createProjectClassLoader(classLoaders[0]);
            if (cls != null) {
                classLoader.setDroolsClassLoader(cls.getClassLoader());
            }
            return classLoader;
        }
        return ClassLoaderUtil.getClassLoader((ClassLoader[])classLoaders, cls, (boolean)enableCache);
    }

    public static ProjectClassLoader createProjectClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (parent == null) {
            parent = ProjectClassLoader.class.getClassLoader();
        }
        return new ProjectClassLoader(parent);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent) {
        if (parent == null) {
            return ProjectClassLoader.createProjectClassLoader();
        }
        return parent instanceof ProjectClassLoader ? (ProjectClassLoader)parent : new ProjectClassLoader(parent);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, Map<String, byte[]> store) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(parent);
        projectClassLoader.store = store;
        return projectClassLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.nonExistingClasses.contains(name)) {
            throw dummyCFNE;
        }
        if (this.droolsClassLoader != null) {
            try {
                return Class.forName(name, resolve, this.droolsClassLoader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Class.forName(name, resolve, this.getParent());
            }
            catch (ClassNotFoundException e2) {
                byte[] bytecode = this.getBytecode(JavaDialectRuntimeData.convertClassToResourcePath(name));
                if (bytecode == null) {
                    this.nonExistingClasses.add(name);
                    throw e2;
                }
                return this.defineClass(name, bytecode, 0, bytecode.length);
            }
        }
    }

    public Class<?> defineClass(String name, byte[] bytecode) {
        return this.defineClass(name, JavaDialectRuntimeData.convertClassToResourcePath(name), bytecode);
    }

    public Class<?> defineClass(String name, String resourceName, byte[] bytecode) {
        this.storeClass(name, resourceName, bytecode);
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    public void storeClass(String name, String resourceName, byte[] bytecode) {
        String pkgName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
            this.definePackage(pkgName, "", "", "", "", "", "", null);
        }
        if (this.store == null) {
            this.store = new HashMap<String, byte[]>();
        }
        this.store.put(resourceName, bytecode);
        this.nonExistingClasses.remove(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytecode = this.getBytecode(name);
        return bytecode != null ? new ByteArrayInputStream(bytecode) : super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource;
        if (this.droolsClassLoader != null && (resource = this.droolsClassLoader.getResource(name)) != null) {
            return resource;
        }
        return super.getResource(name);
    }

    public byte[] getBytecode(String resourceName) {
        return this.store == null ? null : this.store.get(resourceName);
    }

    public Map<String, byte[]> getStore() {
        return this.store;
    }

    public void setDroolsClassLoader(ClassLoader droolsClassLoader) {
        if (this.getParent() != droolsClassLoader) {
            this.droolsClassLoader = droolsClassLoader;
            this.nonExistingClasses.clear();
        }
    }

    public void initFrom(ProjectClassLoader other) {
        if (other.store != null) {
            if (this.store == null) {
                this.store = new HashMap<String, byte[]>();
            }
            this.store.putAll(other.store);
        }
        this.nonExistingClasses.addAll(other.nonExistingClasses);
    }
}

