/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.RightTupleKey;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.PropagationContext;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.KnowledgeRuntime;

public class MarshallerReaderContext
extends ObjectInputStream {
    public final MarshallerReaderContext stream = this;
    public final InternalRuleBase ruleBase;
    public InternalWorkingMemory wm;
    public KnowledgeRuntime kruntime;
    public final Map<Integer, BaseNode> sinks;
    public Map<Integer, InternalFactHandle> handles;
    public final Map<RightTupleKey, RightTuple> rightTuples;
    public final Map<Integer, LeftTuple> terminalTupleMap;
    public final ProtobufInputMarshaller.PBActivationsFilter filter;
    public final ObjectMarshallingStrategyStore resolverStrategyFactory;
    public final Map<Integer, ObjectMarshallingStrategy> usedStrategies;
    public final Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> strategyContexts;
    public final Map<String, EntryPointId> entryPoints;
    public final Map<Integer, TimersInputMarshaller> readersByInt;
    public final Map<Long, PropagationContext> propagationContexts;
    public final boolean marshalProcessInstances;
    public final boolean marshalWorkItems;
    public final Environment env;
    public final Map<Integer, Object> nodeMemories;
    public Object parameterObject;
    public ClassLoader classLoader;
    public Map<Integer, Map<ProtobufInputMarshaller.TupleKey, PhreakTimerNode.Scheduler>> timerNodeSchedulers;

    public MarshallerReaderContext(InputStream stream, InternalRuleBase ruleBase, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Map<Integer, TimersInputMarshaller> timerReaders, Environment env) throws IOException {
        this(stream, ruleBase, sinks, resolverStrategyFactory, timerReaders, true, true, env);
    }

    public MarshallerReaderContext(InputStream stream, InternalRuleBase ruleBase, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Map<Integer, TimersInputMarshaller> timerReaders, boolean marshalProcessInstances, boolean marshalWorkItems, Environment env) throws IOException {
        super(stream);
        this.ruleBase = ruleBase;
        this.sinks = sinks;
        this.readersByInt = timerReaders;
        this.handles = new HashMap<Integer, InternalFactHandle>();
        this.rightTuples = new HashMap<RightTupleKey, RightTuple>();
        this.terminalTupleMap = new HashMap<Integer, LeftTuple>();
        this.filter = new ProtobufInputMarshaller.PBActivationsFilter();
        this.entryPoints = new HashMap<String, EntryPointId>();
        this.propagationContexts = new HashMap<Long, PropagationContext>();
        if (resolverStrategyFactory == null) {
            ObjectMarshallingStrategy[] strats = (ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
            if (strats == null) {
                strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
            }
            this.resolverStrategyFactory = new ObjectMarshallingStrategyStoreImpl(strats);
        } else {
            this.resolverStrategyFactory = resolverStrategyFactory;
        }
        this.usedStrategies = new HashMap<Integer, ObjectMarshallingStrategy>();
        this.strategyContexts = new HashMap<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context>();
        this.marshalProcessInstances = marshalProcessInstances;
        this.marshalWorkItems = marshalWorkItems;
        this.env = env;
        this.nodeMemories = new HashMap<Integer, Object>();
        this.timerNodeSchedulers = new HashMap<Integer, Map<ProtobufInputMarshaller.TupleKey, PhreakTimerNode.Scheduler>>();
        this.parameterObject = null;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            if (this.classLoader == null && this.ruleBase != null) {
                this.classLoader = this.ruleBase.getRootClassLoader();
            }
            return Class.forName(name, false, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }

    public void addTimerNodeScheduler(int nodeId, ProtobufInputMarshaller.TupleKey key, PhreakTimerNode.Scheduler scheduler) {
        Map<ProtobufInputMarshaller.TupleKey, PhreakTimerNode.Scheduler> timers = this.timerNodeSchedulers.get(nodeId);
        if (timers == null) {
            timers = new HashMap<ProtobufInputMarshaller.TupleKey, PhreakTimerNode.Scheduler>();
            this.timerNodeSchedulers.put(nodeId, timers);
        }
        timers.put(key, scheduler);
    }

    public PhreakTimerNode.Scheduler removeTimerNodeScheduler(int nodeId, ProtobufInputMarshaller.TupleKey key) {
        Map<ProtobufInputMarshaller.TupleKey, PhreakTimerNode.Scheduler> timers = this.timerNodeSchedulers.get(nodeId);
        if (timers != null) {
            PhreakTimerNode.Scheduler scheduler = timers.remove(key);
            if (timers.isEmpty()) {
                this.timerNodeSchedulers.remove(nodeId);
            }
            return scheduler;
        }
        return null;
    }
}

