/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.SessionConfiguration;
import org.drools.core.StatelessSession;
import org.drools.core.StatelessSessionResult;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalStatelessSession;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryFactory;
import org.drools.core.event.AgendaEventListener;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.RuleBaseEventListener;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.WorkingMemoryEventListener;
import org.drools.core.event.WorkingMemoryEventSupport;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.reteoo.ReteStatelessSessionResult;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.GlobalExporter;
import org.drools.core.spi.GlobalResolver;

public class ReteooStatelessSession
implements StatelessSession,
InternalStatelessSession,
Externalizable {
    private WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport();
    private AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    private RuleEventListenerSupport ruleEventListenerSupport = new RuleEventListenerSupport();
    private GlobalResolver globalResolver = new MapGlobalResolver();
    private GlobalExporter globalExporter;
    private InternalRuleBase ruleBase;
    private AgendaFilter agendaFilter;
    private SessionConfiguration sessionConf;
    private WorkingMemoryFactory wmFactory;

    public ReteooStatelessSession() {
    }

    public ReteooStatelessSession(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.wmFactory = ruleBase.getConfiguration().getComponentFactory().getWorkingMemoryFactory();
        this.sessionConf = SessionConfiguration.getDefaultInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ruleBase = (InternalRuleBase)in.readObject();
        this.agendaFilter = (AgendaFilter)in.readObject();
        this.globalResolver = (GlobalResolver)in.readObject();
        this.globalExporter = (GlobalExporter)in.readObject();
        this.sessionConf = SessionConfiguration.getDefaultInstance();
        this.wmFactory = this.ruleBase.getConfiguration().getComponentFactory().getWorkingMemoryFactory();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ruleBase);
        out.writeObject(this.agendaFilter);
        out.writeObject(this.globalResolver);
        out.writeObject(this.globalExporter);
    }

    @Override
    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalWorkingMemory newWorkingMemory() {
        this.ruleBase.readLock();
        try {
            InternalWorkingMemory wm = this.wmFactory.createWorkingMemory(this.ruleBase.nextWorkingMemoryCounter(), this.ruleBase, this.ruleBase.newFactHandleFactory(), null, 1L, this.sessionConf, EnvironmentFactory.newEnvironment(), this.workingMemoryEventSupport, this.agendaEventSupport, this.ruleEventListenerSupport, null);
            wm.setGlobalResolver(this.globalResolver);
            InternalWorkingMemory internalWorkingMemory = wm;
            return internalWorkingMemory;
        }
        finally {
            this.ruleBase.readUnlock();
        }
    }

    @Override
    public void addEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.removeEventListener(listener);
    }

    @Override
    public List getWorkingMemoryEventListeners() {
        return this.workingMemoryEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    @Override
    public List getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(RuleBaseEventListener listener) {
        this.ruleBase.addEventListener(listener);
    }

    public List getRuleBaseEventListeners() {
        return this.ruleBase.getRuleBaseEventListeners();
    }

    @Override
    public void removeEventListener(RuleBaseEventListener listener) {
        this.ruleBase.removeEventListener(listener);
    }

    @Override
    public void setAgendaFilter(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    @Override
    public void setGlobal(String identifier, Object value) {
        this.globalResolver.setGlobal(identifier, value);
    }

    @Override
    public void setGlobalResolver(GlobalResolver globalResolver) {
        this.globalResolver = globalResolver;
    }

    @Override
    public void setGlobalExporter(GlobalExporter globalExporter) {
        this.globalExporter = globalExporter;
    }

    @Override
    public void execute(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        wm.insert(object);
        wm.fireAllRules(this.agendaFilter);
    }

    @Override
    public void execute(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            wm.insert(array[i]);
        }
        wm.fireAllRules(this.agendaFilter);
    }

    @Override
    public void execute(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            wm.insert(it.next());
        }
        wm.fireAllRules(this.agendaFilter);
    }

    @Override
    public StatelessSessionResult executeWithResults(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        wm.insert(object);
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }

    @Override
    public StatelessSessionResult executeWithResults(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            wm.insert(array[i]);
        }
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }

    @Override
    public StatelessSessionResult executeWithResults(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            wm.insert(it.next());
        }
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }
}

