/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.FileUtils;
import org.kie.commons.cluster.ClusterService;
import org.kie.commons.data.Pair;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.AbstractPath;
import org.kie.commons.java.nio.base.BasicFileAttributesImpl;
import org.kie.commons.java.nio.base.ExtendedAttributeView;
import org.kie.commons.java.nio.base.FileSystemState;
import org.kie.commons.java.nio.base.SeekableByteChannelFileBasedImpl;
import org.kie.commons.java.nio.base.dotfiles.DotFileOption;
import org.kie.commons.java.nio.base.dotfiles.DotFileUtils;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.base.version.VersionAttributeView;
import org.kie.commons.java.nio.base.version.VersionAttributes;
import org.kie.commons.java.nio.channels.AsynchronousFileChannel;
import org.kie.commons.java.nio.channels.SeekableByteChannel;
import org.kie.commons.java.nio.file.AccessDeniedException;
import org.kie.commons.java.nio.file.AccessMode;
import org.kie.commons.java.nio.file.AtomicMoveNotSupportedException;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DeleteOption;
import org.kie.commons.java.nio.file.DirectoryNotEmptyException;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.FileStore;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystemNotFoundException;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.NotDirectoryException;
import org.kie.commons.java.nio.file.NotLinkException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.StandardCopyOption;
import org.kie.commons.java.nio.file.StandardDeleteOption;
import org.kie.commons.java.nio.file.StandardOpenOption;
import org.kie.commons.java.nio.file.attribute.AttributeView;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.java.nio.file.attribute.FileAttributeView;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.java.nio.fs.jgit.JGitFSPath;
import org.kie.commons.java.nio.fs.jgit.JGitFileStore;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystem;
import org.kie.commons.java.nio.fs.jgit.JGitPathImpl;
import org.kie.commons.java.nio.fs.jgit.JGitVersionAttributeView;
import org.kie.commons.java.nio.fs.jgit.util.Daemon;
import org.kie.commons.java.nio.fs.jgit.util.DaemonClient;
import org.kie.commons.java.nio.fs.jgit.util.JGitUtil;
import org.kie.commons.message.MessageType;
import org.kie.commons.validation.Preconditions;

public class JGitFileSystemProvider
implements FileSystemProvider {
    public static final String GIT_DEFAULT_REMOTE_NAME = "origin";
    public static final String GIT_LIST_ROOT_BRANCH_MODE = "listMode";
    private static final String SCHEME = "git";
    public static final String REPOSITORIES_ROOT_DIR = ".niogit";
    public static final boolean DAEMON_DEFAULT_ENABLED = true;
    public static final int DAEMON_DEFAULT_PORT = 9418;
    public static final String DAEMON_DEFAULT_HOST = "localhost";
    public static final boolean DAEMON_DEFAULT_UPLOAD = true;
    private static final String GIT_ENV_PROP_DEST_PATH = "out-dir";
    public static File FILE_REPOSITORIES_ROOT;
    public static boolean DAEMON_ENABLED;
    public static int DAEMON_PORT;
    public static boolean DAEMON_UPLOAD;
    private static String DAEMON_HOST;
    public static final String USER_NAME = "username";
    public static final String PASSWORD = "password";
    public static final String INIT = "init";
    public static final int SCHEME_SIZE;
    public static final int DEFAULT_SCHEME_SIZE;
    private Daemon daemonService = null;
    private FileSystemState state = FileSystemState.NORMAL;
    private boolean hadCommitOnBatchState = false;
    private final Map<String, JGitFileSystem> fileSystems = new ConcurrentHashMap<String, JGitFileSystem>();
    private final Set<JGitFileSystem> closedFileSystems = new HashSet<JGitFileSystem>();
    private final Map<Repository, JGitFileSystem> repoIndex = new ConcurrentHashMap<Repository, JGitFileSystem>();
    private final String fullHostName;
    private final Map<Repository, ClusterService> clusterMap = new ConcurrentHashMap<Repository, ClusterService>();
    private boolean isDefault;

    public static void loadConfig() {
        String bareReposDir = System.getProperty("org.kie.nio.git.dir");
        String enabled = System.getProperty("org.kie.nio.git.daemon.enabled");
        String host = System.getProperty("org.kie.nio.git.daemon.host");
        String port = System.getProperty("org.kie.nio.git.daemon.port");
        String upload = System.getProperty("org.kie.nio.git.daemon.upload");
        FILE_REPOSITORIES_ROOT = bareReposDir == null || bareReposDir.trim().isEmpty() ? new File(REPOSITORIES_ROOT_DIR) : new File(bareReposDir.trim(), REPOSITORIES_ROOT_DIR);
        if (enabled == null || enabled.trim().isEmpty()) {
            DAEMON_ENABLED = true;
        } else {
            try {
                DAEMON_ENABLED = Boolean.valueOf(enabled);
            }
            catch (Exception ex) {
                DAEMON_ENABLED = true;
            }
        }
        if (DAEMON_ENABLED) {
            DAEMON_PORT = port == null || port.trim().isEmpty() ? 9418 : Integer.valueOf(port);
            DAEMON_HOST = host == null || host.trim().isEmpty() ? DAEMON_DEFAULT_HOST : host;
            if (upload == null || upload.trim().isEmpty()) {
                DAEMON_UPLOAD = true;
            } else {
                try {
                    DAEMON_UPLOAD = Boolean.valueOf(upload);
                }
                catch (Exception ex) {
                    DAEMON_UPLOAD = true;
                }
            }
        }
    }

    public void onCloseFileSystem(JGitFileSystem fileSystem) {
        this.closedFileSystems.add(fileSystem);
        if (this.daemonService != null && this.closedFileSystems.size() == this.fileSystems.size()) {
            this.daemonService.stop();
        }
    }

    public static JGitFileSystemProvider getInstance() {
        return DefaultProviderHolder.getDefaultProvider();
    }

    public JGitFileSystemProvider() {
        this.fullHostName = DAEMON_ENABLED ? DAEMON_HOST + ":" + DAEMON_PORT : null;
        String[] repos = FILE_REPOSITORIES_ROOT.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".git");
            }
        });
        if (repos != null) {
            for (String repo : repos) {
                File repoDir = new File(FILE_REPOSITORIES_ROOT, repo);
                if (!repoDir.isDirectory()) continue;
                String name = repoDir.getName().substring(0, repoDir.getName().indexOf(".git"));
                JGitFileSystem fs = new JGitFileSystem(this, this.fullHostName, JGitUtil.newRepository(repoDir, true), name, ListBranchCommand.ListMode.ALL, this.buildCredential(null));
                this.fileSystems.put(name, fs);
                this.repoIndex.put(fs.gitRepo().getRepository(), fs);
            }
        }
        if (DAEMON_ENABLED) {
            this.buildAndStartDaemon();
        } else {
            this.daemonService = null;
        }
    }

    private void buildAndStartDaemon() {
        this.daemonService = new Daemon(new InetSocketAddress(DAEMON_HOST, DAEMON_PORT));
        this.daemonService.getService("git-receive-pack").setEnabled(DAEMON_UPLOAD);
        this.daemonService.setRepositoryResolver(new RepositoryResolverImpl());
        this.daemonService.setReceivePackFactory(new ReceivePackFactory<DaemonClient>(){

            public ReceivePack create(DaemonClient req, final Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                return new ReceivePack(db){
                    {
                        super(x0);
                        final ClusterService clusterService = (ClusterService)JGitFileSystemProvider.this.clusterMap.get(db);
                        final JGitFileSystem fs = (JGitFileSystem)JGitFileSystemProvider.this.repoIndex.get(db);
                        String treeRef = "master";
                        final ObjectId oldHead = JGitUtil.getTreeRefObjectId(db, "master");
                        this.setPreReceiveHook(new PreReceiveHook(){

                            public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                                if (clusterService != null) {
                                    clusterService.lock();
                                }
                            }
                        });
                        this.setPostReceiveHook(new PostReceiveHook(){

                            public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                                ObjectId newHead = JGitUtil.getTreeRefObjectId(db, "master");
                                JGitUtil.notifyDiffs(fs, "master", "<system>", "<system>", oldHead, newHead);
                                if (clusterService != null) {
                                    clusterService.broadcast(new MessageType(){

                                        public String toString() {
                                            return "SYNC_FS";
                                        }

                                        public int hashCode() {
                                            return "SYNC_FS".hashCode();
                                        }
                                    }, (Map)new HashMap<String, String>(){
                                        {
                                            this.put("fs_scheme", JGitFileSystemProvider.SCHEME);
                                            this.put("fs_id", fs.id());
                                            this.put("fs_uri", fs.toString());
                                        }
                                    });
                                    clusterService.unlock();
                                }
                            }
                        });
                    }
                };
            }
        });
        try {
            this.daemonService.start();
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
    }

    public synchronized void forceAsDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException {
        Object _clusterService;
        Git git;
        CredentialsProvider credential;
        ListBranchCommand.ListMode listMode;
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        Preconditions.checkNotNull((String)"env", env);
        String name = this.extractRepoName(uri);
        if (this.fileSystems.containsKey(name)) {
            throw new FileSystemAlreadyExistsException();
        }
        if (env.containsKey(GIT_LIST_ROOT_BRANCH_MODE)) {
            try {
                listMode = ListBranchCommand.ListMode.valueOf((String)((String)env.get(GIT_LIST_ROOT_BRANCH_MODE)));
            }
            catch (Exception ex) {
                listMode = null;
            }
        } else {
            listMode = null;
        }
        boolean bare = true;
        String outPath = (String)env.get(GIT_ENV_PROP_DEST_PATH);
        File repoDest = outPath != null ? new File(outPath) : new File(FILE_REPOSITORIES_ROOT, name + ".git");
        if (env.containsKey(GIT_DEFAULT_REMOTE_NAME)) {
            String originURI = env.get(GIT_DEFAULT_REMOTE_NAME).toString();
            credential = this.buildCredential(env);
            git = JGitUtil.cloneRepository(repoDest, originURI, bare, credential);
        } else {
            credential = this.buildCredential(null);
            git = JGitUtil.newRepository(repoDest, bare);
        }
        JGitFileSystem fs = new JGitFileSystem(this, this.fullHostName, git, name, listMode, credential);
        this.fileSystems.put(name, fs);
        this.repoIndex.put(fs.gitRepo().getRepository(), fs);
        boolean init = false;
        if (env.containsKey(INIT) && Boolean.valueOf(env.get(INIT).toString()).booleanValue()) {
            init = true;
        }
        if (!env.containsKey(GIT_DEFAULT_REMOTE_NAME) && init) {
            try {
                URI initURI = URI.create(this.getScheme() + "://master@" + name + "/readme.md");
                CommentedOption op = this.setupOp(env);
                OutputStream stream = this.newOutputStream(this.getPath(initURI), new OpenOption[]{op});
                String _init = "Repository Init Content\n=======================\n\nYour project description here.";
                stream.write("Repository Init Content\n=======================\n\nYour project description here.".getBytes());
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!bare) {
                // empty if block
            }
        }
        if ((_clusterService = env.get("clusterService")) != null && _clusterService instanceof ClusterService) {
            this.clusterMap.put(git.getRepository(), (ClusterService)_clusterService);
        }
        if (DAEMON_ENABLED && this.daemonService != null && !this.daemonService.isRunning()) {
            this.buildAndStartDaemon();
        }
        return fs;
    }

    private CommentedOption setupOp(Map<String, ?> env) {
        return null;
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.fileSystems.get(this.extractRepoName(uri));
        if (fileSystem == null) {
            throw new FileSystemNotFoundException("No filesystem for uri (" + uri + ") found.");
        }
        if (this.hasSyncFlag(uri)) {
            try {
                String treeRef = "master";
                ObjectId oldHead = JGitUtil.getTreeRefObjectId(fileSystem.gitRepo().getRepository(), "master");
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                JGitUtil.syncRepository(fileSystem.gitRepo(), fileSystem.getCredential(), params.get("sync"), this.hasForceFlag(uri));
                ObjectId newHead = JGitUtil.getTreeRefObjectId(fileSystem.gitRepo().getRepository(), "master");
                JGitUtil.notifyDiffs(fileSystem, "master", "<system>", "<system>", oldHead, newHead);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        return fileSystem;
    }

    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.fileSystems.get(this.extractRepoName(uri));
        if (fileSystem == null) {
            throw new FileSystemNotFoundException();
        }
        try {
            return JGitPathImpl.create(fileSystem, URIUtil.decode((String)this.extractPath(uri)), this.extractHost(uri), false);
        }
        catch (URIException e) {
            return null;
        }
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        return JGitUtil.resolveInputStream(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
    }

    public OutputStream newOutputStream(Path path, final OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        final JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new IOException();
        }
        try {
            final File file = File.createTempFile("gitz", "woot");
            return new FilterOutputStream(new FileOutputStream(file)){

                @Override
                public void close() throws java.io.IOException {
                    super.close();
                    String sessionId = null;
                    String name = null;
                    String email = null;
                    String message = null;
                    TimeZone timeZone = null;
                    Date when = null;
                    if (options != null && options.length > 0) {
                        for (OpenOption option : options) {
                            if (!(option instanceof CommentedOption)) continue;
                            CommentedOption op = (CommentedOption)option;
                            sessionId = op.getSessionId();
                            name = op.getName();
                            email = op.getEmail();
                            message = op.getMessage();
                            timeZone = op.getTimeZone();
                            when = op.getWhen();
                            break;
                        }
                    }
                    JGitUtil.commit(gPath, sessionId, name, email, message, timeZone, when, JGitFileSystemProvider.this.amend(), (Map<String, File>)new HashMap<String, File>(){
                        {
                            this.put(gPath.getPath(), file);
                        }
                    });
                    JGitFileSystemProvider.this.checkAmend();
                }
            };
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel newByteChannel(final Path path, final Set<? extends OpenOption> options, final FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        final JGitPathImpl gPath = this.toPathImpl(path);
        if (this.exists(path) && (options == null || !options.contains(StandardOpenOption.TRUNCATE_EXISTING))) {
            throw new FileAlreadyExistsException(path.toString());
        }
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new IOException();
        }
        try {
            final File file = File.createTempFile("gitz", "woot");
            SeekableByteChannelFileBasedImpl seekableByteChannelFileBasedImpl = new SeekableByteChannelFileBasedImpl(new RandomAccessFile(file, "rw").getChannel()){

                public void close() throws java.io.IOException {
                    super.close();
                    String sessionId = null;
                    String name = null;
                    String email = null;
                    String message = null;
                    TimeZone timeZone = null;
                    Date when = null;
                    if (options != null && options.size() > 0) {
                        for (OpenOption option : options) {
                            if (!(option instanceof CommentedOption)) continue;
                            CommentedOption op = (CommentedOption)option;
                            sessionId = op.getSessionId();
                            name = op.getName();
                            email = op.getEmail();
                            message = op.getMessage();
                            timeZone = op.getTimeZone();
                            when = op.getWhen();
                            break;
                        }
                    }
                    File tempDot = null;
                    if (options != null && options.contains(new DotFileOption())) {
                        JGitFileSystemProvider.this.deleteIfExists(DotFileUtils.dot((Path)path), new DeleteOption[0]);
                        tempDot = File.createTempFile("meta", "dot");
                        DotFileUtils.buildDotFile((Path)path, (OutputStream)new FileOutputStream(tempDot), (FileAttribute[])attrs);
                    }
                    final File dotfile = tempDot;
                    JGitUtil.commit(gPath, sessionId, name, email, message, timeZone, when, JGitFileSystemProvider.this.amend(), (Map<String, File>)new HashMap<String, File>(){
                        {
                            this.put(gPath.getPath(), file);
                            if (dotfile != null) {
                                this.put(JGitFileSystemProvider.this.toPathImpl(DotFileUtils.dot((Path)gPath)).getPath(), dotfile);
                            }
                        }
                    });
                    JGitFileSystemProvider.this.checkAmend();
                }
            };
            return seekableByteChannelFileBasedImpl;
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        finally {
            ((AbstractPath)path).clearCache();
        }
    }

    protected boolean exists(Path path) {
        try {
            this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<Path> pfilter) throws NotDirectoryException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        DirectoryStream.Filter<Path> filter = pfilter == null ? new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        } : pfilter;
        final JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (!((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        final List<JGitUtil.JGitPathInfo> pathContent = JGitUtil.listPathContent(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        return new DirectoryStream<Path>((DirectoryStream.Filter)filter){
            boolean isClosed = false;
            final /* synthetic */ DirectoryStream.Filter val$filter;
            {
                this.val$filter = filter;
            }

            public void close() throws IOException {
                if (this.isClosed) {
                    throw new IOException();
                }
                this.isClosed = true;
            }

            public Iterator<Path> iterator() {
                if (this.isClosed) {
                    throw new IOException();
                }
                return new Iterator<Path>(){
                    private int i = -1;
                    private Path nextEntry = null;
                    public boolean atEof = false;

                    @Override
                    public boolean hasNext() {
                        if (this.nextEntry == null && !this.atEof) {
                            this.nextEntry = this.readNextEntry();
                        }
                        return this.nextEntry != null;
                    }

                    @Override
                    public Path next() {
                        Path result;
                        if (this.nextEntry == null && !this.atEof) {
                            result = this.readNextEntry();
                        } else {
                            result = this.nextEntry;
                            this.nextEntry = null;
                        }
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }

                    private Path readNextEntry() {
                        JGitPathImpl result;
                        block3: {
                            JGitUtil.JGitPathInfo content;
                            JGitPathImpl path;
                            if (this.atEof) {
                                return null;
                            }
                            result = null;
                            do {
                                ++this.i;
                                if (this.i >= pathContent.size()) {
                                    this.atEof = true;
                                    break block3;
                                }
                                content = (JGitUtil.JGitPathInfo)pathContent.get(this.i);
                            } while (!val$filter.accept((Object)(path = JGitPathImpl.create((JGitFileSystem)gPath.getFileSystem(), "/" + content.getPath(), gPath.getHost(), content.getObjectId(), gPath.isRealPath()))));
                            result = path;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void createDirectory(Path path, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (!((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            OutputStream outputStream = this.newOutputStream(path.resolve(".gitignore"), new OpenOption[0]);
            outputStream.write("# empty\n".getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void createLink(Path link, Path existing) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void delete(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            this.deleteRepo(path.getFileSystem());
            return;
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            this.deleteBranch(gPath);
            return;
        }
        this.deleteAsset(gPath, options);
    }

    private boolean deleteRepo(FileSystem fileSystem) {
        File gitDir = ((JGitFileSystem)fileSystem).gitRepo().getRepository().getDirectory();
        fileSystem.close();
        try {
            FileUtils.delete((File)gitDir, (int)1);
            this.closedFileSystems.remove(fileSystem);
            this.fileSystems.remove(((JGitFileSystem)fileSystem).id());
            return true;
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
    }

    public void deleteAsset(JGitPathImpl path, DeleteOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return;
            }
            List<JGitUtil.JGitPathInfo> content = JGitUtil.listPathContent(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitignore")) {
                this.delete(path.resolve(".gitignore"), new DeleteOption[0]);
                this.deleteResource(path, options);
                return;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        this.deleteResource(path, options);
    }

    void deleteResource(JGitPathImpl path, DeleteOption ... options) {
        String sessionId = null;
        String name = null;
        String email = null;
        String message = "delete {" + path.getPath() + "}";
        TimeZone timeZone = null;
        Date when = null;
        if (options != null && options.length > 0) {
            for (DeleteOption option : options) {
                if (!(option instanceof CommentedOption)) continue;
                CommentedOption op = (CommentedOption)option;
                sessionId = op.getSessionId();
                name = op.getName();
                email = op.getEmail();
                message = op.getMessage();
                timeZone = op.getTimeZone();
                when = op.getWhen();
                break;
            }
        }
        JGitUtil.delete(path, sessionId, name, email, message, timeZone, when, this.amend());
        this.checkAmend();
    }

    private boolean deleteNonEmptyDirectory(DeleteOption ... options) {
        for (DeleteOption option : options) {
            if (!option.equals(StandardDeleteOption.NON_EMPTY_DIRECTORIES)) continue;
            return true;
        }
        return false;
    }

    public void deleteBranch(JGitPathImpl path) {
        Ref branch = JGitUtil.getBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
        if (branch == null) {
            throw new NoSuchFileException(path.toString());
        }
        JGitUtil.deleteBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), branch);
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            return this.deleteRepo(path.getFileSystem());
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            return this.deleteBranchIfExists(gPath);
        }
        return this.deleteAssetIfExists(gPath, options);
    }

    public boolean deleteBranchIfExists(JGitPathImpl path) {
        Ref branch = JGitUtil.getBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
        if (branch == null) {
            return false;
        }
        JGitUtil.deleteBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), branch);
        return true;
    }

    public boolean deleteAssetIfExists(JGitPathImpl path, DeleteOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return true;
            }
            List<JGitUtil.JGitPathInfo> content = JGitUtil.listPathContent(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitignore")) {
                this.delete(path.resolve(".gitignore"), new DeleteOption[0]);
                return true;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            return false;
        }
        this.deleteResource(path, options);
        return true;
    }

    private String deleteCommitMessage(String path, DeleteOption ... options) {
        return "delete {" + path + "}";
    }

    public Path readSymbolicLink(Path link) throws UnsupportedOperationException, NotLinkException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        throw new UnsupportedOperationException();
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean isSourceBranch = this.isBranch(gSource);
        boolean isTargetBranch = this.isBranch(gTarget);
        if (isSourceBranch && isTargetBranch) {
            this.copyBranch(gSource, gTarget);
            return;
        }
        this.copyAsset(gSource, gTarget, options);
    }

    private void copyBranch(JGitPathImpl source, JGitPathImpl target) {
        Preconditions.checkCondition((String)"source and taget should have same setup", (!this.hasSameFileSystem(source, target) ? 1 : 0) != 0);
        if (this.existsBranch(target)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!this.existsBranch(source)) {
            throw new NoSuchFileException(target.toString());
        }
        this.createBranch(source, target);
    }

    private void copyAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
            this.copyDirectory(source, target, options);
            return;
        }
        this.copyFile(source, target, options);
    }

    private boolean contains(CopyOption[] options, CopyOption opt) {
        for (CopyOption option : options) {
            if (!option.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private void copyDirectory(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        ArrayList<JGitPathImpl> directories = new ArrayList<JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
            if (pathResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                directories.add(gPath);
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            this.copyFile(gPath, gTarget, new CopyOption[0]);
        }
        for (JGitPathImpl directory : directories) {
            this.createDirectory((Path)this.composePath(target, (JGitPathImpl)directory.getFileName(), new CopyOption[0]), new FileAttribute[0]);
        }
    }

    private JGitPathImpl composePath(JGitPathImpl directory, JGitPathImpl fileName, CopyOption ... options) {
        if (directory.getPath().endsWith("/")) {
            return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + fileName.toString(false))));
        }
        return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + "/" + fileName.toString(false))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(JGitPathImpl source, JGitPathImpl target, final CopyOption ... options) {
        InputStream in = this.newInputStream((Path)source, this.convert(options));
        SeekableByteChannel out = this.newByteChannel((Path)target, (Set<? extends OpenOption>)new HashSet<OpenOption>(){
            {
                this.add(StandardOpenOption.TRUNCATE_EXISTING);
                for (CopyOption _option : options) {
                    if (!(_option instanceof OpenOption)) continue;
                    this.add((OpenOption)_option);
                }
            }
        }, new FileAttribute[0]);
        try {
            int count;
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) > 0) {
                out.write(ByteBuffer.wrap(buffer, 0, count));
            }
            out.close();
            return;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (java.io.IOException e) {
                    throw new IOException((Exception)e);
                }
            }
        }
    }

    private OpenOption[] convert(CopyOption ... options) {
        if (options == null || options.length == 0) {
            return new OpenOption[0];
        }
        ArrayList<OpenOption> newOptions = new ArrayList<OpenOption>(options.length);
        for (CopyOption option : options) {
            if (!(option instanceof OpenOption)) continue;
            newOptions.add((OpenOption)option);
        }
        return newOptions.toArray(new OpenOption[newOptions.size()]);
    }

    private void createBranch(JGitPathImpl source, JGitPathImpl target) {
        JGitUtil.createBranch(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), target.getRefTree());
    }

    private boolean existsBranch(JGitPathImpl path) {
        return JGitUtil.hasBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
    }

    private boolean isBranch(JGitPathImpl path) {
        return path.getPath().length() == 1 && path.getPath().equals("/");
    }

    private boolean isRoot(JGitPathImpl path) {
        return path.getPath().length() == 1 && path.getPath().equals("/");
    }

    private boolean hasSameFileSystem(JGitPathImpl source, JGitPathImpl target) {
        return ((JGitFileSystem)source.getFileSystem()).equals((Object)target);
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        try {
            this.copy(source, target, options);
            this.delete(source, new DeleteOption[0]);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public boolean isSameFile(Path pathA, Path pathB) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"pathA", (Object)pathA);
        Preconditions.checkNotNull((String)"pathB", (Object)pathB);
        JGitPathImpl gPathA = this.toPathImpl(pathA);
        JGitPathImpl gPathB = this.toPathImpl(pathB);
        Pair<JGitUtil.PathType, ObjectId> resultA = JGitUtil.checkPath(((JGitFileSystem)gPathA.getFileSystem()).gitRepo(), gPathA.getRefTree(), gPathA.getPath());
        Pair<JGitUtil.PathType, ObjectId> resultB = JGitUtil.checkPath(((JGitFileSystem)gPathB.getFileSystem()).gitRepo(), gPathB.getRefTree(), gPathB.getPath());
        if (resultA.getK1() == JGitUtil.PathType.FILE && ((ObjectId)resultA.getK2()).equals((AnyObjectId)resultB.getK2())) {
            return true;
        }
        return pathA.equals(pathB);
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        if (gPath.getFileName() == null) {
            return false;
        }
        return this.toPathImpl(path.getFileName()).toString(false).startsWith(".");
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return new JGitFileStore(((JGitFileSystem)this.toPathImpl(path).getFileSystem()).gitRepo().getRepository());
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws NoSuchFileException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)pathResult.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        FileAttributeView resultView = (FileAttributeView)gPath.getAttrView(type);
        if (resultView == null && (type == BasicFileAttributeView.class || type == VersionAttributeView.class || type == JGitVersionAttributeView.class)) {
            JGitVersionAttributeView newView = new JGitVersionAttributeView(gPath);
            gPath.addAttrView((AttributeView)newView);
            return (V)((Object)newView);
        }
        return (V)resultView;
    }

    private ExtendedAttributeView getFileAttributeView(JGitPathImpl path, String name, LinkOption ... options) {
        ExtendedAttributeView view = (ExtendedAttributeView)path.getAttrView(name);
        if (view == null && (name.equals("basic") || name.equals("version"))) {
            JGitVersionAttributeView newView = new JGitVersionAttributeView(path);
            path.addAttrView((AttributeView)newView);
            return newView;
        }
        return view;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)pathResult.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        if (type == BasicFileAttributesImpl.class || type == BasicFileAttributes.class || type == VersionAttributes.class) {
            JGitVersionAttributeView view = this.getFileAttributeView(path, JGitVersionAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return null;
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attributes);
        String[] s = this.split(attributes);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attributes);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        return view.readAttributes(s[1].split(","));
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attribute);
        if (attribute.equals(FileSystemState.FILE_SYSTEM_STATE_ATTR)) {
            try {
                this.state = FileSystemState.valueOf((String)value.toString());
                FileSystemState.valueOf((String)value.toString());
            }
            catch (Exception ex) {
                this.state = FileSystemState.NORMAL;
            }
            this.hadCommitOnBatchState = false;
            return;
        }
        String[] s = this.split(attribute);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attribute);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        view.setAttribute(s[1], value);
    }

    private void checkURI(String paramName, URI uri) throws IllegalArgumentException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getAuthority() == null || uri.getAuthority().isEmpty()) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@") && uri.getPath().indexOf("/", atIndex) == -1) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
    }

    private void checkAmend() {
        if (this.state == FileSystemState.BATCH && !this.hadCommitOnBatchState) {
            this.hadCommitOnBatchState = true;
        }
    }

    private boolean amend() {
        return this.state == FileSystemState.BATCH && this.hadCommitOnBatchState;
    }

    private String extractHost(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@")) {
            return uri.getAuthority() + uri.getPath().substring(0, uri.getPath().indexOf("/", atIndex));
        }
        return uri.getAuthority();
    }

    private String extractRepoName(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractHost(uri);
        int index = host.indexOf(64);
        if (index != -1) {
            return host.substring(index + 1);
        }
        return host;
    }

    private boolean hasSyncFlag(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getQuery() != null) {
            return uri.getQuery().contains("sync");
        }
        return false;
    }

    private boolean hasForceFlag(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getQuery() != null) {
            return uri.getQuery().contains("force");
        }
        return false;
    }

    private static Map<String, String> getQueryParams(URI uri) {
        final String[] params = uri.getQuery().split("&");
        return new HashMap<String, String>(params.length){
            {
                super(x0);
                for (String param : params) {
                    String[] kv = param.split("=");
                    String name = kv[0];
                    String value = kv.length == 2 ? kv[1] : "";
                    this.put(name, value);
                }
            }
        };
    }

    private String extractPath(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractHost(uri);
        String path = uri.toString().substring(this.getSchemeSize(uri) + host.length());
        if (path.startsWith("/:")) {
            return path.substring(2);
        }
        return path;
    }

    private CredentialsProvider buildCredential(Map<String, ?> env) {
        if (env != null && env.containsKey(USER_NAME)) {
            if (env.containsKey(PASSWORD)) {
                return new UsernamePasswordCredentialsProvider(env.get(USER_NAME).toString(), env.get(PASSWORD).toString());
            }
            return new UsernamePasswordCredentialsProvider(env.get(USER_NAME).toString(), "");
        }
        return CredentialsProvider.getDefault();
    }

    private JGitPathImpl toPathImpl(Path path) {
        if (path instanceof JGitPathImpl) {
            return (JGitPathImpl)path;
        }
        throw new IllegalArgumentException("Path not supported by current provider.");
    }

    private String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos);
            s[1] = pos == attribute.length() ? "" : attribute.substring(pos + 1);
        }
        return s;
    }

    private int getSchemeSize(URI uri) {
        if (uri.getScheme().equals(SCHEME)) {
            return SCHEME_SIZE;
        }
        return DEFAULT_SCHEME_SIZE;
    }

    static {
        SCHEME_SIZE = "git://".length();
        DEFAULT_SCHEME_SIZE = "default://".length();
        JGitFileSystemProvider.loadConfig();
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
    }

    private final class RepositoryResolverImpl
    implements RepositoryResolver<DaemonClient> {
        private RepositoryResolverImpl() {
        }

        public Repository open(DaemonClient client, String name) throws RepositoryNotFoundException, ServiceNotAuthorizedException, ServiceNotEnabledException, ServiceMayNotContinueException {
            JGitFileSystem fs = (JGitFileSystem)JGitFileSystemProvider.this.fileSystems.get(name);
            if (fs == null) {
                throw new RepositoryNotFoundException(name);
            }
            return fs.gitRepo().getRepository();
        }
    }

    private static class DefaultProviderHolder {
        static final JGitFileSystemProvider provider = new JGitFileSystemProvider();

        private DefaultProviderHolder() {
        }

        private static JGitFileSystemProvider getDefaultProvider() {
            return provider;
        }
    }
}

