/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceCommand.class);
    private static volatile ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        String interfaceRef = (String)workItem.getParameter("Interface");
        String operationRef = (String)workItem.getParameter("Operation");
        Object parameter = workItem.getParameter("Parameter");
        Client client = this.getWSClient(workItem, interfaceRef);
        Object[] result = client.invoke(operationRef, new Object[]{parameter});
        ExecutionResults results = new ExecutionResults();
        if (result == null || result.length == 0) {
            results.setData("Result", null);
        } else {
            results.setData("Result", result[0]);
        }
        logger.debug("Received sync response {}", result);
        return results;
    }

    protected synchronized Client getWSClient(WorkItem workItem, String interfaceRef) {
        if (clients.containsKey(interfaceRef)) {
            return clients.get(interfaceRef);
        }
        String importLocation = (String)workItem.getParameter("Url");
        String importNamespace = (String)workItem.getParameter("Namespace");
        if (importLocation != null && importLocation.trim().length() > 0 && importNamespace != null && importNamespace.trim().length() > 0) {
            Client client = this.dcf.createClient(importLocation, new QName(importNamespace, interfaceRef), this.getClass().getClassLoader(), null);
            clients.put(interfaceRef, client);
            return client;
        }
        return null;
    }
}

