/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.BooleanDataType;
import org.drools.core.process.core.datatype.impl.type.FloatDataType;
import org.drools.core.process.core.datatype.impl.type.IntegerDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.datatype.impl.type.StringDataType;
import org.drools.core.process.core.datatype.impl.type.UndefinedDataType;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.NodeContainer;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DefinitionsHandler
extends BaseAbstractHandler
implements Handler {
    public DefinitionsHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(null);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        return new Definitions();
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Definitions definitions = (Definitions)parser.getCurrent();
        String namespace = element.getAttribute("targetNamespace");
        List processes = ((ProcessBuildData)parser.getData()).getProcesses();
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        for (Process process : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)process;
            ruleFlowProcess.setMetaData("TargetNamespace", (Object)namespace);
            this.postProcessItemDefinitions((NodeContainer)ruleFlowProcess, itemDefinitions);
        }
        definitions.setTargetNamespace(namespace);
        return definitions;
    }

    public Class<?> generateNodeFor() {
        return Definitions.class;
    }

    private void postProcessItemDefinitions(NodeContainer nodeContainer, Map<String, ItemDefinition> itemDefinitions) {
        if (nodeContainer instanceof ContextContainer) {
            this.setVariablesDataType((ContextContainer)nodeContainer, itemDefinitions);
        }
        for (Node node : nodeContainer.getNodes()) {
            if (node instanceof NodeContainer) {
                this.postProcessItemDefinitions((NodeContainer)node, itemDefinitions);
            }
            if (!(node instanceof ContextContainer)) continue;
            this.setVariablesDataType((ContextContainer)node, itemDefinitions);
        }
    }

    private void setVariablesDataType(ContextContainer container, Map<String, ItemDefinition> itemDefinitions) {
        VariableScope variableScope = (VariableScope)container.getDefaultContext("VariableScope");
        if (variableScope != null) {
            for (Variable variable : variableScope.getVariables()) {
                this.setVariableDataType(variable, itemDefinitions);
            }
        }
    }

    private void setVariableDataType(Variable variable, Map<String, ItemDefinition> itemDefinitions) {
        String itemSubjectRef = (String)variable.getMetaData("ItemSubjectRef");
        if (UndefinedDataType.getInstance().equals(variable.getType()) && itemDefinitions != null && itemSubjectRef != null) {
            Object dataType = new ObjectDataType();
            ItemDefinition itemDefinition = itemDefinitions.get(itemSubjectRef);
            if (itemDefinition != null) {
                String structureRef = itemDefinition.getStructureRef();
                dataType = "java.lang.Boolean".equals(structureRef) || "Boolean".equals(structureRef) ? new BooleanDataType() : ("java.lang.Integer".equals(structureRef) || "Integer".equals(structureRef) ? new IntegerDataType() : ("java.lang.Float".equals(structureRef) || "Float".equals(structureRef) ? new FloatDataType() : ("java.lang.String".equals(structureRef) || "String".equals(structureRef) ? new StringDataType() : ("java.lang.Object".equals(structureRef) || "Object".equals(structureRef) ? new ObjectDataType(structureRef) : new ObjectDataType(structureRef)))));
            }
            variable.setType((DataType)dataType);
        }
    }
}

