/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import org.drools.compiler.compiler.xml.XmlDumper;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.TimerNode;
import org.xml.sax.Attributes;

public class TimerNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by intermediate catch event handler");
    }

    public Class generateNodeFor() {
        return TimerNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        TimerNode timerNode = (TimerNode)node;
        this.writeNode("intermediateCatchEvent", (Node)timerNode, xmlDump, metaDataType);
        xmlDump.append(">" + EOL);
        xmlDump.append("      <timerEventDefinition>" + EOL);
        Timer timer = timerNode.getTimer();
        if (timer != null && (timer.getDelay() != null || timer.getDate() != null)) {
            if (timer.getTimeType() == 1) {
                xmlDump.append("        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeDuration>" + EOL);
            } else if (timer.getTimeType() == 2) {
                if (timer.getPeriod() != null) {
                    xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "###" + XmlDumper.replaceIllegalChars((String)timer.getPeriod()) + "</timeCycle>" + EOL);
                } else {
                    xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeCycle>" + EOL);
                }
            } else if (timer.getTimeType() == 3) {
                xmlDump.append("        <timeDate xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeDate>" + EOL);
            }
        }
        xmlDump.append("      </timerEventDefinition>" + EOL);
        this.endNode("intermediateCatchEvent", xmlDump);
    }
}

