/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.logging.Logger;
import org.switchyard.common.cdi.CDIUtil;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorRegistry;
import org.switchyard.validate.config.model.JavaValidateModel;
import org.switchyard.validate.internal.DuplicateValidatorException;
import org.switchyard.validate.internal.ValidateMessages;
import org.switchyard.validate.internal.ValidatorFactory;
import org.switchyard.validate.internal.ValidatorFactoryClass;
import org.switchyard.validate.internal.ValidatorUtil;

public class ValidatorRegistryLoader {
    private static Logger _log = Logger.getLogger(ValidatorRegistryLoader.class);
    public static final String VALIDATES_XML = "META-INF/switchyard/validates.xml";
    private List<Validator> _validators = new LinkedList<Validator>();
    private ValidatorRegistry _validatorRegistry;
    private List<CreationalContext<?>> _cdiCreationalContexts = new LinkedList();

    public ValidatorRegistryLoader(ValidatorRegistry validatorRegistry) {
        if (validatorRegistry == null) {
            throw ValidateMessages.MESSAGES.nullValidatorRegistryArgument();
        }
        this._validatorRegistry = validatorRegistry;
    }

    public void registerValidators(ValidatesModel validates) throws DuplicateValidatorException {
        if (validates == null) {
            return;
        }
        try {
            for (ValidateModel validateModel : validates.getValidates()) {
                Collection<Validator<?>> validators = this.newValidators(validateModel);
                for (Validator<?> validator : validators) {
                    if (this._validatorRegistry.hasValidator(validator.getName())) {
                        Validator registeredValidator = this._validatorRegistry.getValidator(validator.getName());
                        throw ValidateMessages.MESSAGES.failedToRegisterValidator(this.toDescription(validator), this.toDescription(registeredValidator));
                    }
                    _log.debug((Object)("Adding validator =>, Name:" + validator.getName()));
                    this._validatorRegistry.addValidator(validator);
                    this._validators.add(validator);
                }
            }
        }
        catch (DuplicateValidatorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.unregisterValidators();
            throw e;
        }
    }

    public Validator<?> newValidator(ValidateModel validateModel) {
        return this.newValidators(validateModel).iterator().next();
    }

    public Collection<Validator<?>> newValidators(ValidateModel validateModel) {
        Collection<Validator<?>> validators = null;
        if (validateModel instanceof JavaValidateModel) {
            JavaValidateModel javaValidateModel = (JavaValidateModel)JavaValidateModel.class.cast(validateModel);
            String bean = javaValidateModel.getBean();
            if (bean != null) {
                BeanManager beanManager = CDIUtil.lookupBeanManager();
                if (beanManager == null) {
                    throw ValidateMessages.MESSAGES.cdiBeanManagerNotFound();
                }
                Object validator = null;
                Set beans = beanManager.getBeans(bean);
                if (beans != null && !beans.isEmpty()) {
                    Bean target = (Bean)beans.iterator().next();
                    CreationalContext context = beanManager.createCreationalContext((Contextual)target);
                    validator = beanManager.getReference(target, Object.class, context);
                    this._cdiCreationalContexts.add(context);
                }
                if (validator == null) {
                    throw ValidateMessages.MESSAGES.validatorBeanNotFound(bean);
                }
                validators = ValidatorUtil.newValidators(validator, validateModel.getName());
            } else {
                String className = ((JavaValidateModel)validateModel).getClazz();
                if (className == null) {
                    throw ValidateMessages.MESSAGES.beanOrClassRequired();
                }
                try {
                    Class validateClass = Classes.forName((String)className, ValidatorUtil.class);
                    validators = ValidatorUtil.newValidators(validateClass, validateModel.getName());
                }
                catch (Exception e) {
                    throw ValidateMessages.MESSAGES.errorConstructingValidator(className, e);
                }
            }
        } else {
            ValidatorFactory factory = ValidatorRegistryLoader.newValidatorFactory(validateModel);
            validators = new ArrayList();
            validators.add(factory.newValidator(validateModel));
        }
        if (validators == null || validators.isEmpty()) {
            throw ValidateMessages.MESSAGES.unknownValidateModel(validateModel.getClass().getName());
        }
        return validators;
    }

    private static ValidatorFactory newValidatorFactory(ValidateModel validateModel) {
        ValidatorFactoryClass validatorFactoryClass = validateModel.getClass().getAnnotation(ValidatorFactoryClass.class);
        if (validatorFactoryClass == null) {
            throw ValidateMessages.MESSAGES.validateModelNotAnnotated(validateModel.getClass().getName());
        }
        Class<? extends ValidatorFactory> factoryClass = validatorFactoryClass.value();
        if (!ValidatorFactory.class.isAssignableFrom(factoryClass)) {
            throw ValidateMessages.MESSAGES.invalidValidatorFactoryImplementation(ValidatorFactory.class.getName());
        }
        try {
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            throw ValidateMessages.MESSAGES.failedToInstantiateValidatorFactory(factoryClass.getName());
        }
    }

    public void unregisterValidators() {
        for (Validator validator : this._validators) {
            this._validatorRegistry.removeValidator(validator);
        }
        for (CreationalContext creationalContext : this._cdiCreationalContexts) {
            creationalContext.release();
        }
        this._cdiCreationalContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOOTBValidates() {
        try {
            List resources = Classes.getResources((String)VALIDATES_XML, this.getClass());
            for (URL resource : resources) {
                InputStream configStream = resource.openStream();
                try {
                    ValidatesModel validatesModel = (ValidatesModel)new ModelPuller().pull(configStream);
                    this.registerValidators(validatesModel);
                }
                catch (DuplicateValidatorException e) {
                    _log.debug((Object)e.getMessage(), (Throwable)((Object)e));
                }
                finally {
                    configStream.close();
                }
            }
        }
        catch (IOException e) {
            throw ValidateMessages.MESSAGES.errorReadingValidator(VALIDATES_XML, e);
        }
    }

    private String toDescription(Validator<?> validator) {
        return validator.getClass().getName() + "(" + validator.getName() + ")";
    }
}

