/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.symphonyoss.s2.canon.maven.plugin.MavenLogFactoryAdaptor;
import org.symphonyoss.s2.canon.maven.plugin.TemplateArtifact;
import org.symphonyoss.s2.canon.parser.CanonException;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.ModelSetParserContext;
import org.symphonyoss.s2.canon.parser.log.LoggerFactory;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractMojo {
    private static final String INDENT = "  ";
    private static final String SPEC_SUFFIX = ".json";
    @Parameter(defaultValue="${project.build.directory}", property="canonRoot", required=true)
    private File canonRoot;
    @Parameter(defaultValue="${project.build.directory}/generated-sources", property="targetDir", required=true)
    private File targetDir;
    @Parameter(defaultValue="${project.build.directory}/proforma-sources", property="proformaTargetDir", required=true)
    private File proformaTargetDir;
    @Parameter(property="proformaCopyDir")
    private File proformaCopyDir;
    @Parameter(property="fileDataModel")
    private Properties pomDataModel;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    protected List<?> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="templateArtifacts")
    private TemplateArtifact[] templateArtifacts;
    @Parameter(defaultValue="${project.basedir}/src/main/canon", property="srcDir")
    protected File[] srcDirs;
    @Parameter(defaultValue="false", property="dumpDataModel", required=true)
    private boolean dumpDataModel;
    private Log log;
    private File canonDir;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        void var4_17;
        if (this.project.getPackaging() != null && "pom".equals(this.project.getPackaging().toLowerCase())) {
            this.getLog().info((CharSequence)"Skipping 'pom' packaged project");
            return;
        }
        this.canonDir = new File(this.canonRoot, "canon");
        this.log = this.getLog();
        this.log.info((CharSequence)"Generating sources--------------------------------------------------------------------------");
        this.log.info((CharSequence)("targetDir            = " + this.targetDir));
        this.log.info((CharSequence)("proformaTargetDir    = " + this.proformaTargetDir));
        this.log.info((CharSequence)("proformaCopyDir      = " + this.proformaCopyDir));
        for (File file : this.srcDirs) {
            this.log.info((CharSequence)("srcDir             = " + file));
        }
        for (TemplateArtifact templateArtifact : this.templateArtifacts) {
            if (!templateArtifact.getPrefix().endsWith("/")) {
                templateArtifact.setPrefix(templateArtifact.getPrefix() + "/");
            }
            this.log.info((CharSequence)("templateArtifactId   = " + templateArtifact.getArtifactId()));
            this.log.info((CharSequence)("templateGroupId      = " + templateArtifact.getGroupId()));
            this.log.info((CharSequence)("templateVersion      = " + templateArtifact.getVersion()));
            this.log.info((CharSequence)("templatePrefix       = " + templateArtifact.getPrefix()));
        }
        this.log.info((CharSequence)"pomDataModel-------------------------------------------------------------------------------");
        if (this.pomDataModel != null) {
            for (Map.Entry entry : this.pomDataModel.entrySet()) {
                this.log.info((CharSequence)(entry.getKey() + " = " + entry.getValue()));
            }
        }
        this.log.info((CharSequence)"--------------------------------------------------------------------------------------------");
        for (TemplateArtifact templateArtifact : this.templateArtifacts) {
            this.copyArtefact(this.canonDir, templateArtifact.getGroupId(), templateArtifact.getArtifactId(), templateArtifact.getVersion(), templateArtifact.getPrefix(), null);
        }
        ArrayList<File> srcList = new ArrayList<File>();
        File[] fileArray = this.srcDirs;
        int n = fileArray.length;
        boolean bl = false;
        while (var4_17 < n) {
            File srcDir = fileArray[var4_17];
            this.addSrcFiles(srcList, srcDir);
            ++var4_17;
        }
        if (srcList.isEmpty()) {
            throw new MojoExecutionException("No sources found");
        }
        try {
            ModelSetParserContext modelSetParserContext = new ModelSetParserContext((LoggerFactory)new MavenLogFactoryAdaptor(this.log));
            for (File file : srcList) {
                modelSetParserContext.addGenerationSource(file);
            }
            modelSetParserContext.process();
            GenerationContext generationContext = new GenerationContext(this.targetDir, this.proformaTargetDir, this.proformaCopyDir);
            generationContext.addTemplateDirectory(this.canonDir);
            modelSetParserContext.generate(generationContext);
        }
        catch (CanonException canonException) {
            throw new MojoExecutionException("Generation failed", (Exception)((Object)canonException));
        }
    }

    private void addSrcFiles(List<File> srcList, File srcDir) {
        File[] files = srcDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isFile() && f.getName().endsWith(SPEC_SUFFIX)) {
                    srcList.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                this.addSrcFiles(srcList, f);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File copyArtefact(File canonDir, String artefactGroupId, String artefactArtifactId, String artefactVersion, String artefactPrefix, String artefactSuffix) throws MojoExecutionException {
        try {
            Artifact artefact = this.factory.createArtifact(artefactGroupId, artefactArtifactId, artefactVersion, "", "jar");
            this.artifactResolver.resolve(artefact, this.remoteRepositories, this.localRepository);
            File artefactFile = artefact.getFile();
            this.log.debug((CharSequence)("Artefact file is " + artefactFile.getAbsolutePath()));
            if (artefactFile.isDirectory()) {
                if (artefactPrefix != null) {
                    artefactFile = new File(artefactFile, artefactPrefix);
                }
                if (!artefactFile.isDirectory()) throw new MojoExecutionException("Error copying artefacts, " + artefactFile + " is not a directory");
                this.log.debug((CharSequence)("Copy artefacts from " + artefactFile.getAbsolutePath()));
                try {
                    this.copyFiles(artefactFile, canonDir, artefactSuffix);
                    return artefactFile;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying artefacts from " + artefactFile, (Exception)e);
                }
            }
            try (FileInputStream in = new FileInputStream(artefactFile);
                 JarInputStream jarIn = new JarInputStream(in);){
                JarEntry jarEntry;
                while ((jarEntry = jarIn.getNextJarEntry()) != null) {
                    if ((artefactPrefix == null || jarEntry.getName().startsWith(artefactPrefix)) && (artefactSuffix == null || jarEntry.getName().endsWith(artefactSuffix))) {
                        FileOutputStream out;
                        block48: {
                            String fileName;
                            if (artefactPrefix == null) {
                                fileName = jarEntry.getName();
                                int i = fileName.lastIndexOf(47);
                                if (i > 0) {
                                    fileName = fileName.substring(i);
                                }
                            } else {
                                fileName = jarEntry.getName().substring(artefactPrefix.length());
                            }
                            File file = new File(canonDir, fileName);
                            if (jarEntry.isDirectory()) {
                                this.log.debug((CharSequence)("Artefact dir " + jarEntry.getName()));
                                if (file.exists()) continue;
                                this.log.debug((CharSequence)("Create artefact dir " + file));
                                file.mkdirs();
                                continue;
                            }
                            this.log.debug((CharSequence)("Artefact file " + jarEntry.getName()));
                            out = new FileOutputStream(file);
                            Throwable throwable = null;
                            try {
                                int nbytes;
                                byte[] buf = new byte[1024];
                                while ((nbytes = jarIn.read(buf)) > 0) {
                                    out.write(buf, 0, nbytes);
                                }
                                if (out == null) continue;
                                if (throwable == null) break block48;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (out == null) throw throwable3;
                                    if (throwable == null) {
                                        out.close();
                                        throw throwable3;
                                    }
                                    try {
                                        out.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                out.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        out.close();
                        continue;
                    }
                    this.log.debug((CharSequence)("SKIP Artefact file " + jarEntry.getName()));
                }
                return artefactFile;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying artefacts from " + artefactFile, (Exception)e);
            }
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"can't resolve artefact pom", e);
            return null;
        }
    }

    private void copyFiles(File srcDir, File targetDir, String artefactSuffix) throws FileNotFoundException, IOException {
        File[] files;
        this.log.debug((CharSequence)("Copy artefacts from " + srcDir + " to " + targetDir));
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if ((files = srcDir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    File targetSubDir = new File(targetDir, file.getName());
                    if (!targetSubDir.exists()) {
                        targetSubDir.mkdirs();
                    }
                    this.copyFiles(file, targetSubDir, artefactSuffix);
                    continue;
                }
                if (artefactSuffix != null && !file.getName().endsWith(artefactSuffix)) continue;
                File targetFile = new File(targetDir, file.getName());
                this.log.debug((CharSequence)("Copy artefact " + targetFile));
                try (FileInputStream in = new FileInputStream(file);
                     FileOutputStream out = new FileOutputStream(targetFile);){
                    int nbytes;
                    byte[] buf = new byte[1024];
                    while ((nbytes = in.read(buf)) > 0) {
                        out.write(buf, 0, nbytes);
                    }
                }
            }
        }
    }

    private void dumpMap(String indent, Map<?, ?> map, Set<Object> visitSet) throws MojoExecutionException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.dump(indent, entry.getKey(), entry.getValue(), visitSet);
        }
    }

    private void dumpCollection(String indent, Collection<?> collection, Set<Object> visitSet) throws MojoExecutionException {
        int i = 0;
        for (Object value : collection) {
            this.dump(indent, "[" + i + "]", value, visitSet);
            ++i;
        }
    }

    private void dump(String indent, Object name, Object value, Set<Object> visitSet) throws MojoExecutionException {
        if (value == null) {
            this.log.info((CharSequence)(indent + name + " = NULL"));
            return;
        }
        if (value instanceof String || value instanceof Number || value instanceof Date || value instanceof Class || value instanceof Boolean) {
            this.log.info((CharSequence)(indent + name + " = " + value));
            return;
        }
        if (value instanceof Map && ((Map)value).isEmpty()) {
            this.log.info((CharSequence)(indent + name + " = EMPTY MAP"));
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            this.log.info((CharSequence)(indent + name + " = EMPTY LIST"));
            return;
        }
        if (visitSet.contains(value)) {
            this.log.info((CharSequence)(indent + name + " RECURSION"));
            return;
        }
        visitSet.add(value);
        if (value instanceof Map) {
            this.log.info((CharSequence)(indent + name + " = MAP"));
            this.dumpMap(indent + INDENT, (Map)value, visitSet);
            return;
        }
        if (value instanceof Collection) {
            this.log.info((CharSequence)(indent + name + " = LIST"));
            this.dumpCollection(indent + INDENT, (Collection)value, visitSet);
            return;
        }
        this.log.info((CharSequence)(indent + name + " = OBJECT of type " + value.getClass()));
        this.dumpObject(indent + INDENT, value, visitSet);
    }

    private void dumpObject(String indent, Object v, Set<Object> visitSet) throws MojoExecutionException {
        for (Method m : v.getClass().getMethods()) {
            Object value;
            if (m.getDeclaringClass() == Object.class || Modifier.isStatic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers()) || !m.getName().startsWith("get") || m.getParameterTypes().length != 0) continue;
            try {
                value = m.invoke(v, new Object[0]);
            }
            catch (Exception e) {
                value = e.toString();
            }
            this.dump(indent, m.getName().substring(3, 4).toLowerCase() + m.getName().substring(4), value, visitSet);
        }
    }
}

