/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.parser.CanonException;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.ModelSetParserContext;
import org.symphonyoss.s2.canon.parser.log.Slf4jLogFactoryAdaptor;
import org.symphonyoss.s2.common.writer.IndentedWriter;

public class Canon {
    public static final String TEMPLATE = "template";
    public static final String PROFORMA = "proforma";
    public static final String X_MODEL = "model";
    public static final String X_ID = "id";
    public static final String VERSION = "version";
    public static final String X_ATTRIBUTES = "x-canon-attributes";
    public static final String X_CARDINALITY = "x-canon-cardinality";
    public static final String X_CARDINALITY_LIST = "LIST";
    public static final String X_CARDINALITY_SET = "SET";
    public static final String EXTENDS = "extends";
    public static final String FACADE = "facade";
    public static final String BUILDER_FACADE = "builderFacade";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String MAPPING = "mapping";
    public static final String ENUM = "enum";
    public static final String JAVA_EXTERNAL_PACKAGE = "javaExternalPackage";
    public static final String JAVA_EXTERNAL_TYPE = "javaExternalType";
    public static final String IS_DIRECT_EXTERNAL = "isDirectExternal";
    public static final String MODEL = "model";
    public static final String JAVA_GEN_PACKAGE = "javaGenPackage";
    public static final String JAVA_FACADE_PACKAGE = "javaFacadePackage";
    public static final String YEAR = "year";
    public static final String YEAR_MONTH = "yearMonth";
    public static final String DATE = "date";
    public static final String INPUT_SOURCE = "inputSource";
    public static final String IS_FACADE = "isFacade";
    public static final String TEMPLATE_NAME = "templateName";
    public static final String TEMPLATE_DEBUG = "templateDebug";
    public static final String PATHS = "paths";
    public static final String METHODS = "methods";
    public static final String DOLLAR_REF = "$ref";
    public static final String PARAMETER_SETS = "parameterSets";
    public static final String SCHEMAS = "schemas";
    public static final String PARAMETERS = "parameters";
    public static final String SCHEMA = "schema";
    public static final String X_BASE_PATH = "basePath";
    private boolean verbose_ = false;
    private boolean dryRun_ = false;
    private String sourceDir_ = "src/main/canon";
    private String generationTarget_ = "target/generated-sources";
    private String proformaTarget_ = "target/proforma-sources";
    private String outputDir_ = ".";
    private String proformaCopy_ = null;
    private List<String> fileNames_ = new ArrayList<String>();
    private List<String> errors_ = new ArrayList<String>();
    private List<File> templateDirs_ = new ArrayList<File>();

    public static void main(String[] argv) throws CanonException {
        new Canon().run(argv);
    }

    private void run(String[] argv) throws CanonException {
        ArrayList<File> files;
        block53: {
            File src;
            block51: {
                File[] fileList;
                block52: {
                    for (int i = 0; i < argv.length; ++i) {
                        if (argv[i].startsWith("--")) {
                            switch (argv[i].substring(2)) {
                                case "verbose": {
                                    this.verbose_ = true;
                                    break;
                                }
                                case "dryRun": {
                                    this.dryRun_ = true;
                                    break;
                                }
                                case "templateDir": {
                                    if (++i < argv.length) {
                                        this.templateDirs_.add(new File(argv[i]));
                                        break;
                                    }
                                    this.error("--templateDir requires a directory name to follow.", new Object[0]);
                                    break;
                                }
                                case "sourceDir": {
                                    if (++i < argv.length) {
                                        this.sourceDir_ = argv[i];
                                        break;
                                    }
                                    this.error("--sourceDir requires a directory name to follow.", new Object[0]);
                                    break;
                                }
                                case "outputDir": {
                                    if (++i < argv.length) {
                                        this.outputDir_ = argv[i];
                                        break;
                                    }
                                    this.error("--outputDir requires a directory name to follow.", new Object[0]);
                                    break;
                                }
                                default: {
                                    this.error("Unrecognized flag \"%s\".", argv[i]);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (argv[i].startsWith("-")) {
                            switch (argv[i].substring(1)) {
                                case "v": {
                                    this.verbose_ = true;
                                    break;
                                }
                                case "d": {
                                    this.dryRun_ = true;
                                    break;
                                }
                                case "t": {
                                    if (++i < argv.length) {
                                        this.templateDirs_.add(new File(argv[i]));
                                        break;
                                    }
                                    this.error("-t requires a directory name to follow.", new Object[0]);
                                    break;
                                }
                                case "s": {
                                    if (++i < argv.length) {
                                        this.sourceDir_ = argv[i];
                                        break;
                                    }
                                    this.error("-s requires a directory name to follow.", new Object[0]);
                                    break;
                                }
                                case "o": {
                                    if (++i < argv.length) {
                                        this.outputDir_ = argv[i];
                                        break;
                                    }
                                    this.error("-o requires a directory name to follow.", new Object[0]);
                                    break;
                                }
                                default: {
                                    this.error("Unrecognized flag \"%s\".", argv[i]);
                                    break;
                                }
                            }
                            continue;
                        }
                        this.fileNames_.add(argv[i]);
                    }
                    src = new File(this.sourceDir_);
                    files = new ArrayList<File>();
                    if (!this.fileNames_.isEmpty()) break block51;
                    fileList = src.listFiles();
                    if (fileList != null) break block52;
                    this.error("Source directory \"%s\" does not exist", this.sourceDir_);
                    break block53;
                }
                for (File f : fileList) {
                    if (!f.getName().endsWith(".json")) continue;
                    files.add(f);
                }
                if (!files.isEmpty()) break block53;
                this.error("No source files found in %s", src.getAbsolutePath());
                break block53;
            }
            for (String fileName : this.fileNames_) {
                File f = new File(fileName);
                if (f.isAbsolute()) {
                    files.add(f);
                    continue;
                }
                files.add(new File(src, fileName));
            }
        }
        for (File f : files) {
            if (!f.exists()) {
                this.error("File \"%s\" does not exist.", f.getAbsolutePath());
                continue;
            }
            if (!f.isFile()) {
                this.error("\"%s\" is not a file", f.getAbsolutePath());
                continue;
            }
            if (f.canRead()) continue;
            this.error("File \"%s\" is not readable", f.getAbsolutePath());
        }
        if (this.templateDirs_.isEmpty()) {
            this.error("No template directories specified", new Object[0]);
        } else {
            for (File f : this.templateDirs_) {
                if (!f.exists()) {
                    this.error("Template directory \"%s\" does not exist.", f.getAbsolutePath());
                    continue;
                }
                if (!f.isDirectory()) {
                    this.error("\"%s\" is not a directory", f.getAbsolutePath());
                    continue;
                }
                if (f.canRead()) continue;
                this.error("Template directory \"%s\" is not readable", f.getAbsolutePath());
            }
        }
        if (this.errors_.isEmpty()) {
            this.execute(files);
        } else {
            for (String e : this.errors_) {
                System.err.println(e);
            }
            System.err.println("Aborted.");
        }
    }

    private void execute(List<File> files) throws CanonException {
        if (this.verbose_) {
            System.out.printf("Canon\n", new Object[0]);
            System.out.printf("verbose:          %s\n", this.verbose_);
            System.out.printf("dryRun:           %s\n", this.dryRun_);
            System.out.printf("sourceDir:        %s\n", this.sourceDir_);
            System.out.printf("generationTarget: %s\n", this.generationTarget_);
            System.out.printf("proformaTarget:   %s\n", this.proformaTarget_);
            System.out.printf("proformaCopy:     %s\n", this.proformaCopy_);
            System.out.printf("inputFiles:\n", new Object[0]);
            for (File file : files) {
                System.out.println(file.getAbsolutePath());
            }
        }
        if (this.dryRun_) {
            System.out.println("Dry Run, nothing done.");
        } else {
            ModelSetParserContext modelSetContext = new ModelSetParserContext(new Slf4jLogFactoryAdaptor());
            for (File f : files) {
                modelSetContext.addGenerationSource(f);
            }
            modelSetContext.process();
            IndentedWriter indentedWriter = new IndentedWriter((OutputStream)System.out);
            modelSetContext.visitAllModels(model -> {
                System.out.println("Model " + model);
                Canon.visit(out, model);
            });
            indentedWriter.flush();
            GenerationContext generationContext = new GenerationContext(this.outputDir_ + "/target/generated-sources", this.outputDir_ + "/target/proforma-sources", this.outputDir_ + "/target/proforma-copy");
            for (File d : this.templateDirs_) {
                generationContext.addTemplateDirectory(d);
            }
            modelSetContext.generate(generationContext);
        }
    }

    private void error(String format, Object ... args) {
        this.errors_.add(String.format(format, args));
    }

    private static void visit(IndentedWriter out, ModelElement model) {
        out.openBlock(model.toString());
        for (ModelElement child : model.getChildren()) {
            Canon.visit(out, child);
        }
        out.closeBlock();
    }
}

