/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Type;
import org.symphonyoss.s2.canon.model.ValueMap;
import org.symphonyoss.s2.canon.parser.ParserContext;

public class IntegerType
extends Type {
    private final Long minimum_;
    private final Long maximum_;

    public IntegerType(ModelElement parent, ParserContext context, String name) {
        super(parent, context, "Integer", name);
        this.minimum_ = context.getLongNode("minimum");
        this.maximum_ = context.getLongNode("maximum");
    }

    public Long getMinimum() {
        return this.minimum_;
    }

    public Long getMaximum() {
        return this.maximum_;
    }

    @Override
    public boolean getCanFailValidation() {
        return this.minimum_ != null || this.maximum_ != null;
    }

    public String getMinimumAsString() {
        return this.minimum_ == null ? null : String.valueOf(this.minimum_);
    }

    public String getMaximumAsString() {
        return this.maximum_ == null ? null : String.valueOf(this.maximum_);
    }

    @Override
    public String toString() {
        return super.toString(new ValueMap<String, Long>().append("minimum", this.minimum_).append("maximum", this.maximum_));
    }
}

