/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.Components;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Paths;
import org.symphonyoss.s2.canon.model.Version;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.GenerationException;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.RootParserContext;
import org.symphonyoss.s2.canon.parser.error.CodeGenerationAbortedInfo;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.ParserWarning;
import org.symphonyoss.s2.canon.parser.error.RequiredItemMissingError;

public class Model
extends ModelElement {
    private static final String COMPONENTS = "components";
    private static Logger log_ = LoggerFactory.getLogger(Model.class);
    private Version openapi_;
    private Map<String, String> modelMap_ = new HashMap<String, String>();
    private SimpleDateFormat yearFormat_ = new SimpleDateFormat("yyyy");
    private SimpleDateFormat yearMonthFormat_ = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private URI canonId_;
    private Paths paths_;
    private String basePath_ = "";
    private Set<RootParserContext> referencedContexts_ = new HashSet<RootParserContext>();
    private String canonVersion_;
    private int canonMajorVersion_;
    private int canonMinorVersion_;

    public Model(ParserContext parserContext) {
        super(null, parserContext, "Model");
        block25: for (ParserContext subContext : parserContext) {
            log_.info("Found " + subContext.getName());
            switch (subContext.getName()) {
                case "canon": {
                    this.openapi_ = new Version(this, subContext);
                    this.add(this.openapi_);
                    break;
                }
                case "methods": {
                    this.paths_ = new Paths(this, subContext);
                    this.add(this.paths_);
                    break;
                }
                case "paths": {
                    if (subContext.isEmpty()) continue block25;
                    subContext.raise(new ParserWarning("OpenAPI Paths are ignored", new Object[0]));
                    break;
                }
                case "info": 
                case "components": {
                    break;
                }
                case "model": {
                    JsonNode jsonNode = subContext.getJsonNode();
                    if (!(jsonNode instanceof ObjectNode)) continue block25;
                    Iterator it = jsonNode.fields();
                    while (it.hasNext()) {
                        Map.Entry entry = (Map.Entry)it.next();
                        this.modelMap_.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                    }
                    continue block25;
                }
                case "id": {
                    try {
                        this.canonId_ = new URI(subContext.getJsonNode().asText());
                        this.modelMap_.put("id", this.canonId_.toString());
                    }
                    catch (URISyntaxException e) {
                        log_.error("id is not a valid URI", (Throwable)e);
                    }
                    break;
                }
                case "version": {
                    this.canonVersion_ = subContext.getJsonNode().asText();
                    String[] parts = this.canonVersion_.split("\\.");
                    if (parts.length == 2) {
                        try {
                            this.canonMajorVersion_ = Integer.parseInt(parts[0]);
                            this.canonMinorVersion_ = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException e) {
                            parserContext.raise(new ParserError("%s must be a 2 element semantic version (each element must be an integer)", "version"));
                        }
                        break;
                    }
                    parserContext.raise(new ParserError("%s must be a 2 element semantic version", "version"));
                    break;
                }
                case "basePath": {
                    this.basePath_ = subContext.getJsonNode().asText();
                    break;
                }
                default: {
                    log_.warn("Unrecognized top level element \"" + subContext.getName() + "\" ignored.");
                }
            }
        }
        if (this.canonId_ == null) {
            parserContext.raise(new RequiredItemMissingError("id"));
        }
        Date now = new Date();
        this.modelMap_.put("year", this.yearFormat_.format(now));
        this.modelMap_.put("yearMonth", this.yearMonthFormat_.format(now));
        this.modelMap_.put("date", this.dateFormat_.format(now));
        this.modelMap_.put("inputSource", parserContext.getRootParserContext().getInputSource());
        this.add(COMPONENTS, new Components(this, parserContext.get(COMPONENTS)));
        parserContext.getRootParserContext().setModel(this);
    }

    @Override
    public Model getModel() {
        return this;
    }

    public Version getOpenapi() {
        return this.openapi_;
    }

    public Map<String, String> getModelMap() {
        return this.modelMap_;
    }

    public URI getCanonId() {
        return this.canonId_;
    }

    public String getCanonVersion() {
        return this.canonVersion_;
    }

    public int getCanonMajorVersion() {
        return this.canonMajorVersion_;
    }

    public int getCanonMinorVersion() {
        return this.canonMinorVersion_;
    }

    public String getBasePath() {
        return this.basePath_;
    }

    public Paths getPaths() {
        return this.paths_;
    }

    public void generate(GenerationContext generationContext) throws GenerationException {
        if (this.getContext().getRootParserContext().hasErrors()) {
            this.getContext().raise(new CodeGenerationAbortedInfo());
        } else {
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            dataModel.putAll(generationContext.getDataModel());
            dataModel.putAll(this.modelMap_);
            log_.info("GENERATE");
            for (Map.Entry entry : dataModel.entrySet()) {
                log_.info((String)entry.getKey() + "=" + entry.getValue());
            }
            this.generate(generationContext, dataModel);
        }
    }

    @Override
    public String toString() {
        return "Model(" + this.canonId_ + ")";
    }

    public void addReferencedContext(RootParserContext referencedContext) {
        this.referencedContexts_.add(referencedContext);
    }

    public Set<RootParserContext> getReferencedContexts() {
        return this.referencedContexts_;
    }
}

