/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.Files;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.EnumSchema;
import org.symphonyoss.s2.canon.model.IPathNameConstructor;
import org.symphonyoss.s2.canon.model.JavaPathNameConstructor;
import org.symphonyoss.s2.canon.model.Model;
import org.symphonyoss.s2.canon.model.PathNameConstructor;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.GenerationException;
import org.symphonyoss.s2.canon.parser.ParserContext;

public class ModelElement {
    private static Logger log_ = LoggerFactory.getLogger(ModelElement.class);
    private ModelElement parent_;
    private final ParserContext parserContext_;
    private final String elementType_;
    private final String name_;
    private final String camelName_;
    private final String camelCapitalizedName_;
    private final String snakeName_;
    private final String snakeCapitalizedName_;
    private List<ModelElement> children_ = new ArrayList<ModelElement>();
    private Map<String, ModelElement> nameMap_ = new HashMap<String, ModelElement>();
    private Map<String, IPathNameConstructor> templatePathBuilderMap_ = new HashMap<String, IPathNameConstructor>();
    private Map<String, IPathNameConstructor> proformaPathBuilderMap_ = new HashMap<String, IPathNameConstructor>();
    private Map<String, String> attributes_ = new HashMap<String, String>();
    private final String summary_;
    private final String description_;
    private String format_ = "";

    public ModelElement(ModelElement parent, ParserContext parserContext, String type) {
        this(parent, parserContext, type, parserContext.getName());
    }

    public ModelElement(ModelElement parent, ParserContext parserContext, String type, String name) {
        JsonNode jsonNode;
        this.parent_ = parent;
        this.parserContext_ = parserContext;
        this.elementType_ = type;
        this.summary_ = parserContext.getText("summary");
        this.description_ = parserContext.getText("description");
        this.format_ = parserContext.getText("format", "");
        this.name_ = name;
        this.camelName_ = this.toCamelCase(this.name_);
        this.camelCapitalizedName_ = ModelElement.capitalize(this.camelName_);
        this.snakeName_ = this.toSnakeCase(this.name_);
        this.snakeCapitalizedName_ = ModelElement.capitalize(this.snakeName_);
        PathNameConstructor defaultPathNameConstructor = new PathNameConstructor();
        this.templatePathBuilderMap_.put("java", new JavaPathNameConstructor("javaGenPackage"));
        this.templatePathBuilderMap_.put(null, defaultPathNameConstructor);
        this.proformaPathBuilderMap_.put("java", new JavaPathNameConstructor("javaFacadePackage"));
        this.proformaPathBuilderMap_.put(null, defaultPathNameConstructor);
        ParserContext canon = parserContext.get("x-canon-attributes");
        if (canon != null && (jsonNode = canon.getJsonNode()) instanceof ObjectNode) {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                this.attributes_.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
    }

    public ModelElement getBaseSchema() {
        return this;
    }

    public ModelElement getComponent() {
        return this;
    }

    public ModelElement getElementSchema() {
        return this;
    }

    public ModelElement getElementComponent() {
        return this;
    }

    public boolean getIsArraySchema() {
        return false;
    }

    public boolean getIsObjectSchema() {
        return false;
    }

    public Map<String, String> getAttributes() {
        return this.attributes_;
    }

    private String toCamelCase(String name) {
        int i;
        StringBuilder s = new StringBuilder();
        for (i = 0; i < name.length() && name.charAt(i) == '_'; ++i) {
            s.append('_');
        }
        if (i < name.length()) {
            s.append(Character.toLowerCase(name.charAt(i++)));
        }
        while (i < name.length()) {
            char c;
            if ((c = name.charAt(i++)) == '_' && i < name.length()) {
                s.append(Character.toUpperCase(name.charAt(i++)));
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    private String toSnakeCase(String name) {
        int i = 0;
        StringBuilder s = new StringBuilder(Character.toLowerCase(name.charAt(i)));
        while (i < name.length()) {
            char c;
            if (Character.isUpperCase(c = name.charAt(i++))) {
                if (i > 1) {
                    s.append('_');
                }
                s.append(Character.toLowerCase(c));
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Model getModel() {
        return this.parent_.getModel();
    }

    public String getName() {
        return this.name_;
    }

    public String getCamelName() {
        return this.camelName_;
    }

    public String getCamelCapitalizedName() {
        return this.camelCapitalizedName_;
    }

    public String getSnakeName() {
        return this.snakeName_;
    }

    public String getSnakeCapitalizedName() {
        return this.snakeCapitalizedName_;
    }

    public String getSummary() {
        return this.summary_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getFormat() {
        return this.format_;
    }

    public boolean getHasSet() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasSet()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasList() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasList()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasCollections() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasCollections()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasByteString() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasByteString()) continue;
            return true;
        }
        return false;
    }

    public boolean getIsComponent() {
        return false;
    }

    public boolean getIsTypeDef() {
        return false;
    }

    public boolean getIsObjectType() {
        return false;
    }

    public boolean getIsGenerateFacade() {
        return false;
    }

    public boolean getIsGenerateBuilderFacade() {
        return false;
    }

    public ModelElement getReference() {
        return this;
    }

    public EnumSchema getEnum() {
        return null;
    }

    public Set<AbstractSchema> getReferencedTypes() {
        HashSet<AbstractSchema> result = new HashSet<AbstractSchema>();
        this.getReferencedTypes(result);
        return result;
    }

    protected void getReferencedTypes(Set<AbstractSchema> result) {
        for (ModelElement child : this.getChildren()) {
            child.getReferencedTypes(result);
        }
    }

    public Set<AbstractSchema> getSchemas() {
        HashSet<AbstractSchema> result = new HashSet<AbstractSchema>();
        this.getSchemas(result);
        return result;
    }

    protected void getSchemas(Set<AbstractSchema> result) {
        for (ModelElement child : this.getChildren()) {
            child.getSchemas(result);
        }
    }

    public void resolve() {
        log_.debug("Resolve " + this.toString());
        for (ModelElement child : this.children_) {
            child.resolve();
        }
    }

    public void validate() {
        log_.debug("Validate " + this.toString());
        for (ModelElement child : this.children_) {
            child.validate();
        }
    }

    public void add(ModelElement e) {
        if (e != null) {
            this.children_.add(e);
        }
    }

    public ModelElement getParent() {
        return this.parent_;
    }

    void setParent(ModelElement parent) {
        this.parent_ = parent;
    }

    public ParserContext getContext() {
        return this.parserContext_;
    }

    public String getElementType() {
        return this.elementType_;
    }

    public List<ModelElement> getChildren() {
        return this.children_;
    }

    public List<ModelElement> getFields() {
        return this.getChildren();
    }

    public void generate(GenerationContext generationContext, Map<String, Object> dataModel) throws GenerationException {
        log_.debug("Generate prologue {}", (Object)this.toString());
        for (String language : generationContext.getLanguages()) {
            Set<String> templates = generationContext.getTemplatesFor("template", language, this.getElementType());
            if (!templates.isEmpty()) {
                dataModel.remove("isFacade");
                this.generate(generationContext, dataModel, templates, language, this.templatePathBuilderMap_, generationContext.getFreemarkerConfig(), generationContext.getTargetDir(), null);
            }
            if ((templates = generationContext.getTemplatesFor("proforma", language, this.getElementType())).isEmpty()) continue;
            dataModel.put("isFacade", "true");
            this.generate(generationContext, dataModel, templates, language, this.proformaPathBuilderMap_, generationContext.getFreemarkerConfig(), generationContext.getProformaDir(), generationContext.getCopyDir());
        }
        this.generateChildren(generationContext, dataModel);
        log_.debug("Generate epilogue {}", (Object)this.toString());
    }

    protected void generateChildren(GenerationContext generationContext, Map<String, Object> dataModel) throws GenerationException {
        for (ModelElement child : this.children_) {
            child.generate(generationContext, dataModel);
        }
    }

    private void generate(GenerationContext generationContext, Map<String, Object> dataModel, Set<String> templates, String language, Map<String, IPathNameConstructor> pathBuilderMap, Configuration freemarkerConfig, File targetDir, File copyDir) throws GenerationException {
        IPathNameConstructor pathBuilder = pathBuilderMap.get(language);
        if (pathBuilder == null) {
            pathBuilder = pathBuilderMap.get(null);
        }
        log_.debug("Generate generate {}", (Object)this.toString());
        for (String templateName : templates) {
            log_.debug("Generate generate {} {}", (Object)this.toString(), (Object)templateName);
            File templateFile = new File(templateName);
            dataModel.put("templateName", templateName);
            String className = pathBuilder.constructFile(dataModel, language, templateFile.getName(), this);
            if (className == null) continue;
            log_.debug("class " + className);
            try {
                Template template = freemarkerConfig.getTemplate(templateName);
                this.generate(generationContext, template, className, dataModel, targetDir, copyDir);
            }
            catch (IOException e) {
                throw new GenerationException("ERROR processing " + this.name_ + " template " + templateName, e);
            }
        }
    }

    private void generate(GenerationContext generationContext, Template template, String className, Map<String, Object> dataModel, File targetDir, File copyDir) throws GenerationException {
        File genPath = new File(targetDir, className);
        genPath.getParentFile().mkdirs();
        dataModel.put("model", this);
        try (FileWriter writer = new FileWriter(genPath);){
            template.process(dataModel, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            throw new GenerationException(e);
        }
        if (genPath.length() == 0L) {
            genPath.delete();
        } else if (copyDir != null) {
            File copyPath = new File(copyDir, className);
            if (copyPath.exists()) {
                log_.info("Proforma " + copyPath.getAbsolutePath() + " exists, not copying");
            } else {
                copyPath.getParentFile().mkdirs();
                try {
                    Files.copy((File)genPath, (File)copyPath);
                }
                catch (IOException e) {
                    throw new GenerationException(e);
                }
            }
        }
    }

    protected void add(String name, ModelElement element) {
        if (element != null) {
            this.nameMap_.put(name, element);
            this.add(element);
        }
    }

    public ModelElement getByPath(String[] pathNames, int index) {
        if (pathNames.length <= index) {
            return null;
        }
        ModelElement modelElement = this.nameMap_.get(pathNames[index]);
        if (pathNames.length == index + 1) {
            return modelElement;
        }
        if (modelElement instanceof ModelElement) {
            return modelElement.getByPath(pathNames, index + 1);
        }
        return null;
    }

    public boolean getCanFailValidation() {
        return false;
    }

    public String toString() {
        return this.elementType_ + " name=" + this.getName();
    }
}

