/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ValueMap<K, V>
implements Iterable<Entry<K, V>> {
    private List<Entry<K, V>> entrySet_ = new LinkedList<Entry<K, V>>();
    private Map<String, Entry<K, V>> entryMap_ = new HashMap<String, Entry<K, V>>();

    public ValueMap<K, V> insert(K name, V value, V defaultValue) {
        return this.put(name, value, defaultValue, true);
    }

    public ValueMap<K, V> append(K name, V value, V defaultValue) {
        return this.put(name, value, defaultValue, false);
    }

    private ValueMap<K, V> put(K name, V value, V defaultValue, boolean insert) {
        if (value != null && !value.equals(defaultValue)) {
            Entry<K, V> entry = this.entryMap_.get(name);
            if (entry == null) {
                entry = new Entry<K, V>(name, value);
                if (insert) {
                    this.entrySet_.add(0, entry);
                } else {
                    this.entrySet_.add(entry);
                }
            } else {
                entry.setValue(value);
            }
        }
        return this;
    }

    public ValueMap<K, V> insert(K name, V value) {
        return this.put(name, value, true);
    }

    public ValueMap<K, V> append(K name, V value) {
        return this.put(name, value, false);
    }

    private ValueMap<K, V> put(K name, V value, boolean insert) {
        Entry<K, V> entry = this.entryMap_.get(name);
        if (entry == null) {
            entry = new Entry<K, V>(name, value);
            if (insert) {
                this.entrySet_.add(0, entry);
            } else {
                this.entrySet_.add(entry);
            }
        } else {
            entry.setValue(value);
        }
        return this;
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return this.entrySet_.iterator();
    }

    public static class Entry<K, V> {
        private K key_;
        private V value_;

        Entry(K key, V value) {
            this.key_ = key;
            this.value_ = value;
        }

        public K getKey() {
            return this.key_;
        }

        public V getValue() {
            return this.value_;
        }

        void setValue(V value) {
            this.value_ = value;
        }
    }
}

