/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.Model;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.parser.ParserContext;

public class Version
extends ModelElement {
    Logger log_ = LoggerFactory.getLogger(Version.class);
    private int major_ = 0;
    private int minor_ = 0;
    private int patch_ = 0;

    public Version(Model parent, ParserContext parserContext) {
        super(parent, parserContext, "Version");
        String[] parts = parserContext.getJsonNode().asText().split("\\.");
        if (parts.length == 3) {
            try {
                this.major_ = Integer.parseInt(parts[0]);
                this.minor_ = Integer.parseInt(parts[1]);
                this.patch_ = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                this.log_.error("Version number must be 3 part semver value, each part must be an integer");
            }
        } else {
            this.log_.error("Version number must be 3 part semver value");
        }
    }

    @Override
    public String toString() {
        return String.format("Version(%d.%d.%d)", this.major_, this.minor_, this.patch_);
    }
}

