/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.symphonyoss.s2.canon.model.Model;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.GenerationException;
import org.symphonyoss.s2.canon.parser.IModelVisitor;
import org.symphonyoss.s2.canon.parser.Parser;
import org.symphonyoss.s2.canon.parser.ParsingException;
import org.symphonyoss.s2.canon.parser.RootParserContext;
import org.symphonyoss.s2.canon.parser.log.Logger;
import org.symphonyoss.s2.canon.parser.log.LoggerFactory;
import org.symphonyoss.s2.canon.parser.log.Slf4jLogFactoryAdaptor;

public class ModelSetParserContext {
    private LoggerFactory logFactory_;
    private Logger log_;
    private Map<URL, RootParserContext> generationContexts_ = new HashMap<URL, RootParserContext>();
    private Map<URL, RootParserContext> referencedContexts_ = new HashMap<URL, RootParserContext>();
    private Deque<RootParserContext> parseQueue_ = new LinkedList<RootParserContext>();
    private Deque<Model> validateQueue_ = new LinkedList<Model>();
    private Deque<Model> generateQueue_ = new LinkedList<Model>();
    private Map<URL, Model> modelMap_ = new HashMap<URL, Model>();

    public ModelSetParserContext() {
        this(new Slf4jLogFactoryAdaptor());
    }

    public ModelSetParserContext(LoggerFactory logFactory) {
        this.logFactory_ = logFactory;
        this.log_ = logFactory.getLogger(this.getClass());
        this.log_.info("ModelSetParserContext created");
    }

    public LoggerFactory getLogFactory() {
        return this.logFactory_;
    }

    public void addGenerationSource(File file) throws ParsingException {
        try {
            URL url = file.toURI().toURL();
            RootParserContext context = new RootParserContext(this, url, false);
            this.generationContexts_.put(url, context);
            this.parseQueue_.add(context);
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    public void addGenerationSource(URL baseUrl, Reader reader) throws ParsingException {
        RootParserContext context = new RootParserContext(this, baseUrl, reader, false);
        this.generationContexts_.put(baseUrl, context);
        this.parseQueue_.add(context);
    }

    public Model parseOneModel() throws ParsingException {
        RootParserContext context = this.parseQueue_.pollFirst();
        if (context == null) {
            throw new ParsingException("No models left to parse");
        }
        Parser parser = new Parser();
        Model model = parser.parse(context);
        this.validateQueue_.add(model);
        this.modelMap_.put(context.getUrl(), model);
        return model;
    }

    public void process() throws ParsingException {
        Model model;
        RootParserContext context;
        Parser parser = new Parser();
        while ((context = this.parseQueue_.pollFirst()) != null) {
            model = parser.parse(context);
            this.validateQueue_.add(model);
            this.modelMap_.put(context.getUrl(), model);
        }
        while ((model = this.validateQueue_.pollFirst()) != null) {
            this.validate(model);
            if (model.getContext().getRootParserContext().getErrors().isEmpty()) continue;
            throw new ParsingException("Generation failed for " + model.getContext().getRootParserContext().getInputSourceName());
        }
    }

    public void validate(Model model) {
        model.resolve();
        model.validate();
        if (!model.getContext().getRootParserContext().isReferencedModel()) {
            this.generateQueue_.add(model);
        }
        model.getContext().getRootParserContext().epilogue("Validation");
    }

    public RootParserContext addReferencedModel(URL url) throws ParsingException {
        RootParserContext context = this.referencedContexts_.get(url);
        if (context == null) {
            context = new RootParserContext(this, url, true);
            this.referencedContexts_.put(url, context);
            this.parseQueue_.add(context);
        }
        return context;
    }

    public Model getModel(URL url) {
        return this.modelMap_.get(url);
    }

    public void generate(GenerationContext generationContext) throws GenerationException {
        for (Model model : this.generateQueue_) {
            model.generate(generationContext);
            model.getContext().getRootParserContext().epilogue("Generation");
        }
    }

    public void visitAllModels(IModelVisitor visitor) {
        for (Model model : this.generateQueue_) {
            visitor.visit(model);
        }
    }
}

