/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.Set;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Schema;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ArraysRequireElementsError;
import org.symphonyoss.s2.canon.parser.error.ParserError;

public class ArraySchema
extends Schema {
    private final AbstractSchema items_;
    private final String cardinality_;
    private final Long minItems_;
    private final Long maxItems_;

    public ArraySchema(ModelElement parent, ParserContext context, String name) {
        super(parent, context, "ArraySchema", name);
        ParserContext items = context.get("items");
        if (items == null) {
            context.raise(new ArraysRequireElementsError());
            this.items_ = null;
        } else {
            this.items_ = AbstractSchema.createSchema(this, items);
            this.add(this.items_);
        }
        this.minItems_ = context.getLongNode("minItems");
        this.maxItems_ = context.getLongNode("maxItems");
        switch (context.getText("x-canon-cardinality", "LIST")) {
            case "SET": {
                this.cardinality_ = "SET";
                break;
            }
            default: {
                this.cardinality_ = "LIST";
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.items_ == null) {
            this.getContext().raise(new ParserError("Array items must be specified", new Object[0]));
        } else {
            this.items_.validate();
        }
    }

    @Override
    public Schema getElementSchema() {
        return this.items_.getBaseSchema();
    }

    @Override
    public ModelElement getElementComponent() {
        return this.items_.getComponent();
    }

    @Override
    public boolean getIsArraySchema() {
        return true;
    }

    @Override
    public boolean getIsObjectSchema() {
        return this.items_.getIsObjectSchema();
    }

    public AbstractSchema getItems() {
        return this.items_;
    }

    public Long getMinItems() {
        return this.minItems_;
    }

    public Long getMaxItems() {
        return this.maxItems_;
    }

    public String getCardinality() {
        return this.cardinality_;
    }

    @Override
    public boolean getHasSet() {
        return "SET".equals(this.cardinality_);
    }

    @Override
    public boolean getHasList() {
        return "LIST".equals(this.cardinality_);
    }

    @Override
    public boolean getHasCollections() {
        return true;
    }

    @Override
    public boolean getHasByteString() {
        return this.items_.getHasByteString();
    }

    @Override
    public void getReferencedTypes(Set<AbstractSchema> result) {
        super.getReferencedTypes(result);
        this.items_.getReferencedTypes(result);
    }

    @Override
    public boolean getCanFailValidation() {
        return this.minItems_ != null || this.maxItems_ != null || super.getCanFailValidation();
    }
}

